/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.integration.atlassian;

import com.atlassian.confluence.event.events.security.LoginEvent;
import com.atlassian.confluence.event.events.security.LoginFailedEvent;
import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import com.atlassian.seraph.auth.LoginReason;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.jasig.cas.client.validation.Assertion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class Confluence35CasAuthenticator
extends ConfluenceAuthenticator {
    private static final long serialVersionUID = -6097438206488390678L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Confluence35CasAuthenticator.class);

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        Principal existingUser = this.getUserFromSession(request);
        if (existingUser != null) {
            LOGGER.debug("Session found; user already logged in.");
            LoginReason.OK.stampRequestResponse(request, response);
            return existingUser;
        }
        HttpSession session = request.getSession();
        Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
        if (assertion != null) {
            String username = assertion.getPrincipal().getName();
            Principal user = this.getUser(username);
            String remoteIP = request.getRemoteAddr();
            String remoteHost = request.getRemoteHost();
            if (user != null) {
                this.putPrincipalInSessionContext(request, user);
                this.getElevatedSecurityGuard().onSuccessfulLoginAttempt(request, username);
                this.getEventPublisher().publish((Object)new LoginEvent((Object)this, username, request.getSession().getId(), remoteHost, remoteIP));
                LoginReason.OK.stampRequestResponse(request, response);
                LOGGER.debug("Logging in [{}] from CAS.", (Object)username);
            } else {
                LOGGER.debug("Failed logging [{}] from CAS.", (Object)username);
                this.getElevatedSecurityGuard().onFailedLoginAttempt(request, username);
                this.getEventPublisher().publish((Object)new LoginFailedEvent((Object)this, username, request.getSession().getId(), remoteHost, remoteIP));
            }
            return user;
        }
        return super.getUser(request, response);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        HttpSession session = request.getSession();
        Principal principal = (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        if (principal != null) {
            LOGGER.debug("Logging out [{}] from CAS.", (Object)principal.getName());
        }
        this.removePrincipalFromSessionContext(request);
        session.setAttribute("_const_cas_assertion_", null);
        return true;
    }
}

