/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.client.integration.atlassian;

import com.atlassian.confluence.user.ConfluenceAuthenticator;
import com.atlassian.seraph.auth.AuthenticatorException;
import java.security.Principal;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.jasig.cas.client.validation.Assertion;

public final class ConfluenceCasAuthenticator
extends ConfluenceAuthenticator {
    private static final long serialVersionUID = -6097438206488390677L;
    private static final Log LOG = LogFactory.getLog(ConfluenceCasAuthenticator.class);

    public Principal getUser(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession();
        if (session.getAttribute("seraph_defaultauthenticator_user") != null) {
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)"Session found; user already logged in.");
            }
            return (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        }
        Assertion assertion = (Assertion)session.getAttribute("_const_cas_assertion_");
        if (assertion != null) {
            Principal p = this.getUser(assertion.getPrincipal().getName());
            if (LOG.isDebugEnabled()) {
                LOG.debug((Object)("Logging in [" + p.getName() + "] from CAS."));
            }
            session.setAttribute("seraph_defaultauthenticator_user", (Object)p);
            session.setAttribute("seraph_defaultauthenticator_logged_out_user", null);
            return p;
        }
        return super.getUser(request, response);
    }

    public boolean logout(HttpServletRequest request, HttpServletResponse response) throws AuthenticatorException {
        HttpSession session = request.getSession();
        Principal principal = (Principal)session.getAttribute("seraph_defaultauthenticator_user");
        if (LOG.isDebugEnabled()) {
            LOG.debug((Object)("Logging out [" + principal.getName() + "] from CAS."));
        }
        session.setAttribute("seraph_defaultauthenticator_logged_out_user", (Object)principal);
        session.setAttribute("seraph_defaultauthenticator_user", null);
        session.setAttribute("_const_cas_assertion_", null);
        return true;
    }
}

