/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius.authentication.handler.support;

import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import javax.security.auth.login.FailedLoginException;
import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;
import net.jradius.packet.attribute.RadiusAttribute;
import org.jasig.cas.adaptors.radius.RadiusResponse;
import org.jasig.cas.adaptors.radius.RadiusServer;
import org.jasig.cas.authentication.Credential;
import org.jasig.cas.authentication.HandlerResult;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.cas.authentication.UsernamePasswordCredential;
import org.jasig.cas.authentication.handler.support.AbstractUsernamePasswordAuthenticationHandler;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component(value="radiusAuthenticationHandler")
public class RadiusAuthenticationHandler
extends AbstractUsernamePasswordAuthenticationHandler {
    @NotNull
    @Size(min=1)
    @Resource(name="radiusServers")
    private List<RadiusServer> servers;
    @Value(value="${cas.radius.failover.authn:false}")
    private boolean failoverOnException;
    @Value(value="${cas.radius.failover.exception:false}")
    private boolean failoverOnAuthenticationFailure;

    public RadiusAuthenticationHandler() {
        this.logger.debug("Using {}", (Object)((Object)((Object)this)).getClass().getSimpleName());
    }

    protected final HandlerResult authenticateUsernamePasswordInternal(UsernamePasswordCredential credential) throws GeneralSecurityException, PreventedException {
        String password = this.getPasswordEncoder().encode(credential.getPassword());
        String username = credential.getUsername();
        for (RadiusServer radiusServer : this.servers) {
            this.logger.debug("Attempting to authenticate {} at {}", (Object)username, (Object)radiusServer);
            try {
                RadiusResponse response = radiusServer.authenticate(username, password);
                if (response != null) {
                    HashMap<String, String> attributes = new HashMap<String, String>();
                    for (RadiusAttribute attribute : response.getAttributes()) {
                        attributes.put(attribute.getAttributeName(), attribute.getValue().toString());
                    }
                    return this.createHandlerResult((Credential)credential, this.principalFactory.createPrincipal(username, attributes), new ArrayList());
                }
                if (!this.failoverOnAuthenticationFailure) {
                    throw new FailedLoginException("Radius authentication failed for user " + username);
                }
                this.logger.debug("failoverOnAuthenticationFailure enabled -- trying next server");
            }
            catch (PreventedException e) {
                if (!this.failoverOnException) {
                    throw e;
                }
                this.logger.warn("failoverOnException enabled -- trying next server.", (Throwable)e);
            }
        }
        throw new FailedLoginException("Radius authentication failed for user " + username);
    }

    public final void setFailoverOnAuthenticationFailure(boolean failoverOnAuthenticationFailure) {
        this.failoverOnAuthenticationFailure = failoverOnAuthenticationFailure;
    }

    public final void setFailoverOnException(boolean failoverOnException) {
        this.failoverOnException = failoverOnException;
    }

    public final void setServers(List<RadiusServer> servers) {
        this.servers = servers;
    }
}

