/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.adaptors.radius;

import java.io.Serializable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import net.jradius.client.RadiusClient;
import net.jradius.dictionary.Attr_NASIPAddress;
import net.jradius.dictionary.Attr_NASIPv6Address;
import net.jradius.dictionary.Attr_NASIdentifier;
import net.jradius.dictionary.Attr_NASPort;
import net.jradius.dictionary.Attr_NASPortId;
import net.jradius.dictionary.Attr_NASPortType;
import net.jradius.dictionary.Attr_UserName;
import net.jradius.dictionary.Attr_UserPassword;
import net.jradius.dictionary.vsa_redback.Attr_NASRealPort;
import net.jradius.packet.AccessAccept;
import net.jradius.packet.AccessRequest;
import net.jradius.packet.attribute.AttributeFactory;
import net.jradius.packet.attribute.AttributeList;
import net.jradius.packet.attribute.RadiusAttribute;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.adaptors.radius.JRadiusServerImpl$AjcClosure1;
import org.jasig.cas.adaptors.radius.RadiusClientFactory;
import org.jasig.cas.adaptors.radius.RadiusProtocol;
import org.jasig.cas.adaptors.radius.RadiusResponse;
import org.jasig.cas.adaptors.radius.RadiusServer;
import org.jasig.cas.authentication.PreventedException;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class JRadiusServerImpl
implements RadiusServer {
    public static final int DEFAULT_RETRY_COUNT = 3;
    private static final Logger LOGGER;
    @NotNull
    private final RadiusProtocol protocol;
    @NotNull
    private final RadiusClientFactory radiusClientFactory;
    @Min(value=0L)
    private int retries = 3;
    private String nasIpAddress;
    private String nasIpv6Address;
    private long nasPort = -1L;
    private long nasPortId = -1L;
    private String nasIdentifier;
    private long nasRealPort = -1L;
    private long nasPortType = -1L;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;

    static {
        JRadiusServerImpl.ajc$preClinit();
        LOGGER = LoggerFactory.getLogger(JRadiusServerImpl.class);
        AttributeFactory.loadAttributeDictionary((String)"net.jradius.dictionary.AttributeDictionaryImpl");
    }

    public JRadiusServerImpl(RadiusProtocol protocol, RadiusClientFactory clientFactory) {
        this.protocol = protocol;
        this.radiusClientFactory = clientFactory;
    }

    @Override
    public RadiusResponse authenticate(String username, String password) throws PreventedException {
        String string = username;
        String string2 = password;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)this, (Object)this, (Object)string, (Object)string2);
        Object[] objectArray = new Object[]{this, string, string2, joinPoint};
        return (RadiusResponse)TraceLogAspect.aspectOf().traceMethod(new JRadiusServerImpl$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setNasIpAddress(String nasIpAddress) {
        this.nasIpAddress = nasIpAddress;
    }

    public void setNasIpv6Address(String nasIpv6Address) {
        this.nasIpv6Address = nasIpv6Address;
    }

    public void setNasPort(long nasPort) {
        this.nasPort = nasPort;
    }

    public void setNasPortId(long nasPortId) {
        this.nasPortId = nasPortId;
    }

    public void setNasIdentifier(String nasIdentifier) {
        this.nasIdentifier = nasIdentifier;
    }

    public void setNasRealPort(long nasRealPort) {
        this.nasRealPort = nasRealPort;
    }

    public void setNasPortType(long nasPortType) {
        this.nasPortType = nasPortType;
    }

    public void setRetries(int retries) {
        this.retries = retries;
    }

    static final /* synthetic */ RadiusResponse authenticate_aroundBody0(JRadiusServerImpl ajc$this, String username, String password, JoinPoint joinPoint) {
        AttributeList attributeList = new AttributeList();
        attributeList.add((RadiusAttribute)new Attr_UserName((Serializable)((Object)username)));
        attributeList.add((RadiusAttribute)new Attr_UserPassword((Serializable)((Object)password)));
        if (StringUtils.isNotBlank((CharSequence)ajc$this.nasIpAddress)) {
            attributeList.add((RadiusAttribute)new Attr_NASIPAddress((Serializable)((Object)ajc$this.nasIpAddress)));
        }
        if (StringUtils.isNotBlank((CharSequence)ajc$this.nasIpv6Address)) {
            attributeList.add((RadiusAttribute)new Attr_NASIPv6Address((Serializable)((Object)ajc$this.nasIpv6Address)));
        }
        if (StringUtils.isNotBlank((CharSequence)ajc$this.nasIdentifier)) {
            attributeList.add((RadiusAttribute)new Attr_NASIdentifier((Serializable)((Object)ajc$this.nasIdentifier)));
        }
        if (ajc$this.nasPort != -1L) {
            attributeList.add((RadiusAttribute)new Attr_NASPort((Serializable)Long.valueOf(ajc$this.nasPort)));
        }
        if (ajc$this.nasPortId != -1L) {
            attributeList.add((RadiusAttribute)new Attr_NASPortId((Serializable)Long.valueOf(ajc$this.nasPortId)));
        }
        if (ajc$this.nasRealPort != -1L) {
            attributeList.add((RadiusAttribute)new Attr_NASRealPort((Serializable)Long.valueOf(ajc$this.nasRealPort)));
        }
        if (ajc$this.nasPortType != -1L) {
            attributeList.add((RadiusAttribute)new Attr_NASPortType((Serializable)Long.valueOf(ajc$this.nasPortType)));
        }
        try (RadiusClient client = null;){
            client = ajc$this.radiusClientFactory.newInstance();
            AccessRequest request = new AccessRequest(client, attributeList);
            net.jradius.packet.RadiusResponse response = client.authenticate(request, RadiusClient.getAuthProtocol((String)ajc$this.protocol.getName()), ajc$this.retries);
            LOGGER.debug("RADIUS response from {}: {}", (Object)client.getRemoteInetAddress().getCanonicalHostName(), (Object)response.getClass().getName());
            if (response instanceof AccessAccept) {
                AccessAccept acceptedResponse = (AccessAccept)response;
                RadiusResponse radiusResponse = new RadiusResponse(acceptedResponse.getCode(), acceptedResponse.getIdentifier(), acceptedResponse.getAttributes().getAttributeList());
                return radiusResponse;
            }
        }
        return null;
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("JRadiusServerImpl.java", JRadiusServerImpl.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "authenticate", "org.jasig.cas.adaptors.radius.JRadiusServerImpl", "java.lang.String:java.lang.String", "username:password", "org.jasig.cas.authentication.PreventedException", "org.jasig.cas.adaptors.radius.RadiusResponse"), 92);
    }
}

