/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry.support.kryo.serial;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.serialize.SimpleSerializer;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AttributeMapSerializer
extends SimpleSerializer<Map<String, Object>> {
    private final Kryo kryo;

    public AttributeMapSerializer(Kryo kryo) {
        this.kryo = kryo;
    }

    public void write(ByteBuffer buffer, Map<String, Object> map) {
        buffer.putInt(map.size());
        for (String key : map.keySet()) {
            this.kryo.writeObjectData(buffer, (Object)key);
            Object value = map.get(key);
            if (value instanceof Collection) {
                Collection items = (Collection)value;
                this.kryo.writeClass(buffer, ArrayList.class);
                buffer.putInt(items.size());
                for (Object o : items) {
                    this.kryo.writeClassAndObject(buffer, o);
                }
                continue;
            }
            this.kryo.writeClassAndObject(buffer, map.get(key));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public Map<String, Object> read(ByteBuffer buffer) {
        int size = buffer.getInt();
        HashMap<String, Object> map = new HashMap<String, Object>(size);
        int i = 0;
        while (i < size) {
            ArrayList<Object> value;
            String key = (String)this.kryo.readObjectData(buffer, String.class);
            Kryo.RegisteredClass registeredClass = this.kryo.readClass(buffer);
            if (registeredClass != null) {
                Class valueClass = registeredClass.getType();
                if (ArrayList.class.isAssignableFrom(valueClass)) {
                    int valueSize = buffer.getInt();
                    ArrayList<Object> items = new ArrayList<Object>(valueSize);
                    int j = 0;
                    while (j < valueSize) {
                        items.add(this.kryo.readClassAndObject(buffer));
                        ++j;
                    }
                    value = items;
                } else {
                    if (!String.class.isAssignableFrom(valueClass)) throw new IllegalStateException("Unexpected attribute value type " + valueClass);
                    value = this.kryo.readObjectData(buffer, String.class);
                }
            } else {
                value = null;
            }
            map.put(key, value);
            ++i;
        }
        return map;
    }
}

