/*
 * Decompiled with CFR 0.152.
 */
package org.jasig.cas.ticket.registry;

import java.io.Serializable;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.Element;
import net.sf.ehcache.config.CacheConfiguration;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.Signature;
import org.aspectj.runtime.internal.Conversions;
import org.aspectj.runtime.reflect.Factory;
import org.jasig.cas.ticket.ServiceTicket;
import org.jasig.cas.ticket.Ticket;
import org.jasig.cas.ticket.TicketGrantingTicket;
import org.jasig.cas.ticket.registry.AbstractDistributedTicketRegistry;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure1;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure11;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure13;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure15;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure3;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure5;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure7;
import org.jasig.cas.ticket.registry.EhCacheTicketRegistry$AjcClosure9;
import org.jasig.inspektr.aspect.TraceLogAspect;
import org.springframework.beans.BeanInstantiationException;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.core.style.ToStringCreator;

public final class EhCacheTicketRegistry
extends AbstractDistributedTicketRegistry
implements InitializingBean {
    private Cache serviceTicketsCache;
    private Cache ticketGrantingTicketsCache;
    private boolean supportRegistryState = true;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_0;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_1;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_2;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_3;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_4;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_5;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_6;
    private static final /* synthetic */ JoinPoint.StaticPart ajc$tjp_7;

    public EhCacheTicketRegistry() {
    }

    public EhCacheTicketRegistry(Cache serviceTicketsCache, Cache ticketGrantingTicketsCache) {
        this.setServiceTicketsCache(serviceTicketsCache);
        this.setTicketGrantingTicketsCache(ticketGrantingTicketsCache);
    }

    public EhCacheTicketRegistry(Cache serviceTicketsCache, Cache ticketGrantingTicketsCache, boolean supportRegistryState) {
        this(serviceTicketsCache, ticketGrantingTicketsCache);
        this.setSupportRegistryState(supportRegistryState);
    }

    public void addTicket(Ticket ticket) {
        Ticket ticket2 = ticket;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_0, (Object)((Object)this), (Object)((Object)this), (Object)ticket2);
        Object[] objectArray = new Object[]{this, ticket2, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure1(objectArray).linkClosureAndJoinPoint(69648));
    }

    public boolean deleteTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_1, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return Conversions.booleanValue((Object)TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure3(objectArray).linkClosureAndJoinPoint(69648)));
    }

    private boolean deleteTicketAndChildren(TicketGrantingTicket ticket) {
        Map services = ticket.getServices();
        if (services != null && !services.isEmpty()) {
            for (Map.Entry entry : services.entrySet()) {
                if (this.serviceTicketsCache.remove((Serializable)entry.getKey())) {
                    this.logger.trace("Removed service ticket [{}]", entry.getKey());
                    continue;
                }
                this.logger.trace("Unable to remove service ticket [{}]", entry.getKey());
            }
        }
        return this.ticketGrantingTicketsCache.remove((Serializable)((Object)ticket.getId()));
    }

    public Ticket getTicket(String ticketId) {
        String string = ticketId;
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_2, (Object)((Object)this), (Object)((Object)this), (Object)string);
        Object[] objectArray = new Object[]{this, string, joinPoint};
        return (Ticket)TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure5(objectArray).linkClosureAndJoinPoint(69648));
    }

    public Collection<Ticket> getTickets() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_3, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (Collection)TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure7(objectArray).linkClosureAndJoinPoint(69648));
    }

    public void setServiceTicketsCache(Cache serviceTicketsCache) {
        this.serviceTicketsCache = serviceTicketsCache;
    }

    public void setTicketGrantingTicketsCache(Cache ticketGrantingTicketsCache) {
        this.ticketGrantingTicketsCache = ticketGrantingTicketsCache;
    }

    public String toString() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_4, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return (String)TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure9(objectArray).linkClosureAndJoinPoint(69648));
    }

    protected void updateTicket(Ticket ticket) {
        this.addTicket(ticket);
    }

    protected boolean needsCallback() {
        return false;
    }

    public void setSupportRegistryState(boolean supportRegistryState) {
        this.supportRegistryState = supportRegistryState;
    }

    public void afterPropertiesSet() throws Exception {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_5, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure11(objectArray).linkClosureAndJoinPoint(69648));
    }

    public int sessionCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_6, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure13(objectArray).linkClosureAndJoinPoint(69648)));
    }

    public int serviceTicketCount() {
        JoinPoint joinPoint = Factory.makeJP((JoinPoint.StaticPart)ajc$tjp_7, (Object)((Object)this), (Object)((Object)this));
        Object[] objectArray = new Object[]{this, joinPoint};
        return Conversions.intValue((Object)TraceLogAspect.aspectOf().traceMethod(new EhCacheTicketRegistry$AjcClosure15(objectArray).linkClosureAndJoinPoint(69648)));
    }

    static {
        EhCacheTicketRegistry.ajc$preClinit();
    }

    static final /* synthetic */ void addTicket_aroundBody0(EhCacheTicketRegistry ajc$this, Ticket ticket, JoinPoint joinPoint) {
        Element element = new Element((Serializable)((Object)ticket.getId()), (Serializable)ticket);
        if (ticket instanceof ServiceTicket) {
            ajc$this.logger.debug("Adding service ticket {} to the cache {}", (Object)ticket.getId(), (Object)ajc$this.serviceTicketsCache.getName());
            ajc$this.serviceTicketsCache.put(element);
        } else if (ticket instanceof TicketGrantingTicket) {
            ajc$this.logger.debug("Adding ticket granting ticket {} to the cache {}", (Object)ticket.getId(), (Object)ajc$this.ticketGrantingTicketsCache.getName());
            ajc$this.ticketGrantingTicketsCache.put(element);
        } else {
            throw new IllegalArgumentException("Invalid ticket type " + ticket);
        }
    }

    static final /* synthetic */ boolean deleteTicket_aroundBody2(EhCacheTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        if (StringUtils.isBlank((CharSequence)ticketId)) {
            return false;
        }
        Ticket ticket = ajc$this.getTicket(ticketId);
        if (ticket == null) {
            return false;
        }
        if (ticket instanceof TicketGrantingTicket) {
            ajc$this.logger.debug("Removing ticket [{}] and its children from the registry.", (Object)ticket);
            return ajc$this.deleteTicketAndChildren((TicketGrantingTicket)ticket);
        }
        ajc$this.logger.debug("Removing ticket [{}] from the registry.", (Object)ticket);
        return ajc$this.serviceTicketsCache.remove((Serializable)((Object)ticketId));
    }

    static final /* synthetic */ Ticket getTicket_aroundBody4(EhCacheTicketRegistry ajc$this, String ticketId, JoinPoint joinPoint) {
        if (ticketId == null) {
            return null;
        }
        Element element = ajc$this.serviceTicketsCache.get((Serializable)((Object)ticketId));
        if (element == null) {
            element = ajc$this.ticketGrantingTicketsCache.get((Serializable)((Object)ticketId));
        }
        return element == null ? null : ajc$this.getProxiedTicketInstance((Ticket)element.getObjectValue());
    }

    static final /* synthetic */ Collection getTickets_aroundBody6(EhCacheTicketRegistry ajc$this, JoinPoint joinPoint) {
        Collection serviceTickets = ajc$this.serviceTicketsCache.getAll((Collection)ajc$this.serviceTicketsCache.getKeysWithExpiryCheck()).values();
        Collection tgtTicketsTickets = ajc$this.ticketGrantingTicketsCache.getAll((Collection)ajc$this.ticketGrantingTicketsCache.getKeysWithExpiryCheck()).values();
        HashSet<Ticket> allTickets = new HashSet<Ticket>(serviceTickets.size() + tgtTicketsTickets.size());
        for (Element ticket : serviceTickets) {
            allTickets.add((Ticket)ticket.getObjectValue());
        }
        for (Element ticket : tgtTicketsTickets) {
            allTickets.add((Ticket)ticket.getObjectValue());
        }
        return allTickets;
    }

    static final /* synthetic */ String toString_aroundBody8(EhCacheTicketRegistry ajc$this, JoinPoint joinPoint) {
        return new ToStringCreator((Object)ajc$this).append("ticketGrantingTicketsCache", (Object)ajc$this.ticketGrantingTicketsCache).append("serviceTicketsCache", (Object)ajc$this.serviceTicketsCache).toString();
    }

    static final /* synthetic */ void afterPropertiesSet_aroundBody10(EhCacheTicketRegistry ajc$this, JoinPoint joinPoint) {
        if (ajc$this.serviceTicketsCache == null || ajc$this.ticketGrantingTicketsCache == null) {
            throw new BeanInstantiationException(((Object)((Object)ajc$this)).getClass(), "Both serviceTicketsCache and ticketGrantingTicketsCache are required properties.");
        }
        if (ajc$this.logger.isDebugEnabled()) {
            CacheConfiguration config = ajc$this.serviceTicketsCache.getCacheConfiguration();
            ajc$this.logger.debug("serviceTicketsCache.maxElementsInMemory={}", (Object)config.getMaxEntriesLocalHeap());
            ajc$this.logger.debug("serviceTicketsCache.maxElementsOnDisk={}", (Object)config.getMaxElementsOnDisk());
            ajc$this.logger.debug("serviceTicketsCache.isOverflowToDisk={}", (Object)config.isOverflowToDisk());
            ajc$this.logger.debug("serviceTicketsCache.timeToLive={}", (Object)config.getTimeToLiveSeconds());
            ajc$this.logger.debug("serviceTicketsCache.timeToIdle={}", (Object)config.getTimeToIdleSeconds());
            ajc$this.logger.debug("serviceTicketsCache.cacheManager={}", (Object)ajc$this.serviceTicketsCache.getCacheManager().getName());
            config = ajc$this.ticketGrantingTicketsCache.getCacheConfiguration();
            ajc$this.logger.debug("ticketGrantingTicketsCache.maxElementsInMemory={}", (Object)config.getMaxEntriesLocalHeap());
            ajc$this.logger.debug("ticketGrantingTicketsCache.maxElementsOnDisk={}", (Object)config.getMaxElementsOnDisk());
            ajc$this.logger.debug("ticketGrantingTicketsCache.isOverflowToDisk={}", (Object)config.isOverflowToDisk());
            ajc$this.logger.debug("ticketGrantingTicketsCache.timeToLive={}", (Object)config.getTimeToLiveSeconds());
            ajc$this.logger.debug("ticketGrantingTicketsCache.timeToIdle={}", (Object)config.getTimeToIdleSeconds());
            ajc$this.logger.debug("ticketGrantingTicketsCache.cacheManager={}", (Object)ajc$this.ticketGrantingTicketsCache.getCacheManager().getName());
        }
    }

    static final /* synthetic */ int sessionCount_aroundBody12(EhCacheTicketRegistry ajc$this, JoinPoint joinPoint) {
        return BooleanUtils.toInteger((boolean)ajc$this.supportRegistryState, (int)ajc$this.ticketGrantingTicketsCache.getKeysWithExpiryCheck().size(), (int)super.sessionCount());
    }

    static final /* synthetic */ int serviceTicketCount_aroundBody14(EhCacheTicketRegistry ajc$this, JoinPoint joinPoint) {
        return BooleanUtils.toInteger((boolean)ajc$this.supportRegistryState, (int)ajc$this.serviceTicketsCache.getKeysWithExpiryCheck().size(), (int)super.serviceTicketCount());
    }

    private static /* synthetic */ void ajc$preClinit() {
        Factory factory = new Factory("EhCacheTicketRegistry.java", EhCacheTicketRegistry.class);
        ajc$tjp_0 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "addTicket", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "org.jasig.cas.ticket.Ticket", "ticket", "", "void"), 100);
        ajc$tjp_1 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "deleteTicket", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "java.lang.String", "ticketId", "", "boolean"), 118);
        ajc$tjp_2 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTicket", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "java.lang.String", "ticketId", "", "org.jasig.cas.ticket.Ticket"), 160);
        ajc$tjp_3 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "getTickets", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "", "", "", "java.util.Collection"), 173);
        ajc$tjp_4 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "toString", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "", "", "", "java.lang.String"), 201);
        ajc$tjp_5 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "afterPropertiesSet", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "", "", "java.lang.Exception", "void"), 237);
        ajc$tjp_6 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "sessionCount", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "", "", "", "int"), 268);
        ajc$tjp_7 = factory.makeSJP("method-execution", (Signature)factory.makeMethodSig("1", "serviceTicketCount", "org.jasig.cas.ticket.registry.EhCacheTicketRegistry", "", "", "", "int"), 278);
    }
}

