/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils.orm.hibernate;

import org.hibernate.cfg.ImprovedNamingStrategy;
import org.hibernate.internal.util.StringHelper;
import org.jarbframework.utils.StringUtils;

public class ConventionNamingStrategy
extends ImprovedNamingStrategy {
    private static final String FOREIGN_KEY_SUFFIX = "_id";

    public String propertyToColumnName(String propertyName) {
        String simplePropertyName = StringHelper.unqualify((String)propertyName);
        return StringUtils.lowerCaseWithUnderscores(simplePropertyName);
    }

    public String tableName(String tableName) {
        return StringUtils.lowerCaseWithUnderscores(tableName);
    }

    public String columnName(String columnName) {
        return StringUtils.lowerCaseWithUnderscores(columnName);
    }

    public String foreignKeyColumnName(String propertyName, String propertyEntityName, String propertyTableName, String referencedColumnName) {
        return super.foreignKeyColumnName(propertyName, propertyEntityName, propertyTableName, referencedColumnName) + FOREIGN_KEY_SUFFIX;
    }
}

