/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils;

public class StringUtils {
    private static final String EMPTY = "";
    private static final int INDEX_NOT_FOUND = -1;

    public static boolean isBlank(String text) {
        return text == null || text.trim().isEmpty();
    }

    public static boolean isNotBlank(String text) {
        return !StringUtils.isBlank(text);
    }

    public static String substringBefore(String text, String separator) {
        int index = StringUtils.indexOf(text, separator);
        return StringUtils.substringBefore(text, index);
    }

    public static String substringBeforeLast(String text, String separator) {
        int index = StringUtils.lastIndexOf(text, separator);
        return StringUtils.substringBefore(text, index);
    }

    private static String substringBefore(String text, int index) {
        if (index == -1) {
            return text;
        }
        return text.substring(0, index);
    }

    public static String substringAfter(String text, String separator) {
        int index = StringUtils.indexOf(text, separator);
        return StringUtils.substringAfter(text, index);
    }

    public static String substringAfterLast(String text, String separator) {
        int index = StringUtils.lastIndexOf(text, separator);
        return StringUtils.substringAfter(text, index);
    }

    private static String substringAfter(String text, int index) {
        if (index == -1) {
            return EMPTY;
        }
        return text.substring(index + 1, text.length());
    }

    private static int indexOf(String text, String separator) {
        if (StringUtils.isBlank(text)) {
            return -1;
        }
        return text.indexOf(separator);
    }

    private static int lastIndexOf(String text, String separator) {
        if (StringUtils.isBlank(text)) {
            return -1;
        }
        return text.lastIndexOf(separator);
    }

    public static boolean startsWithIgnoreCase(String text, String value) {
        return text.toLowerCase().startsWith(value.toLowerCase());
    }

    public static String lowerCaseWithUnderscores(String name) {
        StringBuilder buffer = new StringBuilder(name.replace('.', '_'));
        for (int index = 1; index < buffer.length() - 1; ++index) {
            if (!StringUtils.isSeparator(buffer, index)) continue;
            buffer.insert(index++, '_');
        }
        return buffer.toString().toLowerCase();
    }

    private static boolean isSeparator(StringBuilder buffer, int index) {
        char previous = buffer.charAt(index - 1);
        char current = buffer.charAt(index);
        char next = buffer.charAt(index + 1);
        return !(!Character.isLowerCase(previous) && !Character.isDigit(previous) || !Character.isUpperCase(current) || !Character.isLowerCase(next) && !Character.isDigit(next));
    }
}

