/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.utils;

import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jarbframework.utils.Classes;
import org.jarbframework.utils.JdbcConnectionCallback;

public final class JdbcUtils {
    private JdbcUtils() {
    }

    public static <T> T doWithConnection(String driverClassName, String url, String userName, String password, JdbcConnectionCallback<T> callback) {
        T t;
        Connection connection = null;
        try {
            connection = JdbcUtils.createConnection(driverClassName, url, userName, password);
            t = callback.doWork(connection);
        }
        catch (SQLException e) {
            try {
                throw new RuntimeException(e);
            }
            catch (Throwable throwable) {
                JdbcUtils.closeQuietly(connection);
                throw throwable;
            }
        }
        JdbcUtils.closeQuietly(connection);
        return t;
    }

    private static Connection createConnection(String driverClassName, String url, String userName, String password) throws SQLException {
        Classes.forName(driverClassName);
        return DriverManager.getConnection(url, userName, password);
    }

    public static <T> T doWithConnection(DataSource dataSource, JdbcConnectionCallback<T> callback) {
        Connection connection = null;
        try {
            connection = dataSource.getConnection();
            T t = callback.doWork(connection);
            return t;
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
        finally {
            JdbcUtils.closeQuietly(connection);
        }
    }

    public static void closeQuietly(Connection connection) {
        try {
            if (connection != null) {
                connection.close();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }

    public static void commitSafely(Connection connection) {
        try {
            if (!connection.getAutoCommit()) {
                connection.commit();
            }
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

