/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver.vendor;

import org.jarbframework.constraint.violation.DatabaseConstraintType;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.PatternViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.DatabaseProductSpecific;
import org.jarbframework.utils.DatabaseProduct;
import org.jarbframework.utils.StringUtils;

public class PostgresViolationResolver
extends PatternViolationResolver
implements DatabaseProductSpecific {
    public PostgresViolationResolver() {
        this.register(new CheckPattern());
        this.register(new NotNullPattern());
        this.register(new UniqueKeyPattern());
        this.register(new ForeignKeyNotPresentPattern());
        this.register(new ForeignKeyStillReferencedPattern());
        this.register(new LengthPattern());
        this.register(new InvalidTypePattern());
    }

    @Override
    public boolean supports(DatabaseProduct product) {
        return StringUtils.startsWithIgnoreCase((String)product.getName(), (String)"postgres");
    }

    private static class InvalidTypePattern
    extends PatternViolationResolver.ViolationPattern {
        public InvalidTypePattern() {
            super("ERROR: column \"(.+)\" is of type (.+) but expression is of type (.+)\\nHint: .*");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.INVALID_TYPE).column(variables.get(1)).expectedValueType(variables.get(2)).valueType(variables.get(3)).build();
        }
    }

    private static class LengthPattern
    extends PatternViolationResolver.ViolationPattern {
        public LengthPattern() {
            super("ERROR: value too long for type (.+)\\((.+)\\)");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.LENGTH_EXCEEDED).expectedValueType(variables.get(1)).maximumLength(variables.get(2)).build();
        }
    }

    private static class ForeignKeyStillReferencedPattern
    extends PatternViolationResolver.ViolationPattern {
        public ForeignKeyStillReferencedPattern() {
            super("ERROR: update or delete on table \"(.+)\" violates foreign key constraint \"(.+)\" on table \"(.+)\"\\s+Detail: Key \\((.+)\\)=\\((.+)\\) is still referenced from table \".+\"\\.");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.FOREIGN_KEY).table(variables.get(1)).constraint(variables.get(2)).referencingTable(variables.get(3)).column(variables.get(4)).value(variables.get(5)).build();
        }
    }

    private static class ForeignKeyNotPresentPattern
    extends PatternViolationResolver.ViolationPattern {
        public ForeignKeyNotPresentPattern() {
            super("ERROR: insert or update on table \"(.+)\" violates foreign key constraint \"(.+)\"\\s+Detail: Key \\((.+)\\)=\\((.+)\\) is not present in table \"(.+)\"\\.");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.FOREIGN_KEY).table(variables.get(1)).constraint(variables.get(2)).column(variables.get(3)).referencingTable(variables.get(5)).value(variables.get(4)).build();
        }
    }

    private static class UniqueKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public UniqueKeyPattern() {
            super("ERROR: duplicate key value violates unique constraint \"(.+)\"\\s+Detail: Key \\((.+)\\)=\\((.+)\\) already exists\\.");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.UNIQUE_KEY).constraint(variables.get(1)).column(variables.get(2)).value(variables.get(3)).build();
        }
    }

    private static class NotNullPattern
    extends PatternViolationResolver.ViolationPattern {
        public NotNullPattern() {
            super("ERROR: null value in column \"(.+)\" violates not-null constraint");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.NOT_NULL).column(variables.get(1)).build();
        }
    }

    private static class CheckPattern
    extends PatternViolationResolver.ViolationPattern {
        public CheckPattern() {
            super("ERROR: new row for relation \"(.+)\" violates check constraint \"(.+)\"");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.CHECK_FAILED).constraint(variables.get(2)).table(variables.get(1)).build();
        }
    }
}

