/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver.vendor;

import org.jarbframework.constraint.violation.DatabaseConstraintType;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.PatternViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.DatabaseProductSpecific;
import org.jarbframework.utils.DatabaseProduct;
import org.jarbframework.utils.StringUtils;

public class OracleViolationResolver
extends PatternViolationResolver
implements DatabaseProductSpecific {
    public OracleViolationResolver() {
        this.register(new CheckPattern());
        this.register(new NotNullPattern());
        this.register(new UniqueKeyPattern());
        this.register(new ForeignKeyPattern());
        this.register(new LengthPattern());
        this.register(new InvalidTypePattern());
    }

    @Override
    public boolean supports(DatabaseProduct product) {
        return StringUtils.startsWithIgnoreCase((String)product.getName(), (String)"oracle");
    }

    private static class InvalidTypePattern
    extends PatternViolationResolver.ViolationPattern {
        public InvalidTypePattern() {
            super("(.+): invalid (.+)\n");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.INVALID_TYPE).number(variables.get(1)).expectedValueType(variables.get(2)).build();
        }
    }

    private static class LengthPattern
    extends PatternViolationResolver.ViolationPattern {
        public LengthPattern() {
            super("(.+): value too large for column \"(.+)\"\\.\"(.+)\"\\.\"(.+)\" \\(actual: (\\d+), maximum: (\\d+)\\)\n");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.LENGTH_EXCEEDED).number(variables.get(1)).table(variables.get(3)).column(variables.get(4)).maximumLength(variables.get(6)).build();
        }
    }

    private static class ForeignKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public ForeignKeyPattern() {
            super("(.+): integrity constraint \\((.+)\\.(.+)\\) violated - child record found\n");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.FOREIGN_KEY).number(variables.get(1)).constraint(variables.get(3)).build();
        }
    }

    private static class UniqueKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public UniqueKeyPattern() {
            super("(.+): unique constraint \\((.+)\\.(.+)\\) violated\n");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.UNIQUE_KEY).number(variables.get(1)).constraint(variables.get(3)).build();
        }
    }

    private static class NotNullPattern
    extends PatternViolationResolver.ViolationPattern {
        public NotNullPattern() {
            super("(.+): cannot insert NULL into \\(\"(.+)\"\\.\"(.+)\"\\.\"(.+)\"\\)\n");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.NOT_NULL).number(variables.get(1)).table(variables.get(3)).column(variables.get(4)).build();
        }
    }

    private static class CheckPattern
    extends PatternViolationResolver.ViolationPattern {
        public CheckPattern() {
            super("(.+): check constraint \\((.+)\\.(.+)\\) violated\n");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.CHECK_FAILED).number(variables.get(1)).constraint(variables.get(3)).build();
        }
    }
}

