/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver.vendor;

import org.jarbframework.constraint.violation.DatabaseConstraintType;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.PatternViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.DatabaseProductSpecific;
import org.jarbframework.utils.DatabaseProduct;
import org.jarbframework.utils.StringUtils;

public class MysqlViolationResolver
extends PatternViolationResolver
implements DatabaseProductSpecific {
    public MysqlViolationResolver() {
        this.register(new NotNullPattern());
        this.register(new UniqueKeyPattern());
        this.register(new LengthPattern());
        this.register(new InvalidTypePattern());
    }

    @Override
    public boolean supports(DatabaseProduct product) {
        return StringUtils.startsWithIgnoreCase((String)product.getName(), (String)"mysql");
    }

    private static class InvalidTypePattern
    extends PatternViolationResolver.ViolationPattern {
        public InvalidTypePattern() {
            super("Incorrect (\\w+) value: '(.+)' for column '(.+)' at row (\\d+)");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.INVALID_TYPE).expectedValueType(variables.get(1)).value(variables.get(2)).column(variables.get(3)).build();
        }
    }

    private static class LengthPattern
    extends PatternViolationResolver.ViolationPattern {
        public LengthPattern() {
            super("Data truncation: Data too long for column '(.+)' at row (\\d+)");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.LENGTH_EXCEEDED).column(variables.get(1)).build();
        }
    }

    private static class UniqueKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public UniqueKeyPattern() {
            super("Duplicate entry '(.+)' for key '(.+)'");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.UNIQUE_KEY).value(variables.get(1)).constraint(variables.get(2)).build();
        }
    }

    private static class NotNullPattern
    extends PatternViolationResolver.ViolationPattern {
        public NotNullPattern() {
            super("Column '(.+)' cannot be null");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.NOT_NULL).column(variables.get(1)).build();
        }
    }
}

