/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver.vendor;

import org.jarbframework.constraint.violation.DatabaseConstraintType;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.PatternViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.DatabaseProductSpecific;
import org.jarbframework.utils.DatabaseProduct;

public class HsqlViolationResolver
extends PatternViolationResolver
implements DatabaseProductSpecific {
    public HsqlViolationResolver() {
        this.register(new NotNullPattern());
        this.register(new UniqueKeyPattern());
        this.register(new ForeignKeyPattern());
        this.register(new LengthPattern());
        this.register(new InvalidTypePattern());
    }

    @Override
    public boolean supports(DatabaseProduct product) {
        return "HSQL Database Engine".equals(product.getName());
    }

    private static class InvalidTypePattern
    extends PatternViolationResolver.ViolationPattern {
        public InvalidTypePattern() {
            super("data exception: invalid (.+) value for cast");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.INVALID_TYPE).valueType(variables.get(1).toLowerCase()).build();
        }
    }

    private static class LengthPattern
    extends PatternViolationResolver.ViolationPattern {
        public LengthPattern() {
            super("data exception: (.+) data, right truncation");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.LENGTH_EXCEEDED).valueType(variables.get(1).toLowerCase()).build();
        }
    }

    private static class ForeignKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public ForeignKeyPattern() {
            super("integrity constraint violation: foreign key no \\w+; (.+) table: (.+)");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.FOREIGN_KEY).constraint(variables.get(1).toLowerCase()).table(variables.get(2).toLowerCase()).build();
        }
    }

    private static class UniqueKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public UniqueKeyPattern() {
            super("integrity constraint violation: unique constraint or index violation; (.+) table: (.+)");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.UNIQUE_KEY).constraint(variables.get(1).toLowerCase()).table(variables.get(2).toLowerCase()).build();
        }
    }

    private static class NotNullPattern
    extends PatternViolationResolver.ViolationPattern {
        public NotNullPattern() {
            super("integrity constraint violation: NOT NULL check constraint; (.+) table: (.+) column: (.+)");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.NOT_NULL).constraint(variables.get(1).toLowerCase()).table(variables.get(2).toLowerCase()).column(variables.get(3).toLowerCase()).build();
        }
    }
}

