/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver.vendor;

import org.jarbframework.constraint.violation.DatabaseConstraintType;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.PatternViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.DatabaseProductSpecific;
import org.jarbframework.utils.DatabaseProduct;

public class H2ViolationResolver
extends PatternViolationResolver
implements DatabaseProductSpecific {
    private static final String REGEX_SUFFIX = " SQL statement:\n(.*) \\[(.*)\\]";

    public H2ViolationResolver() {
        this.register(new NotNullPattern());
        this.register(new UniqueKeyPattern());
        this.register(new ForeignKeyPattern());
        this.register(new LengthPattern());
        this.register(new InvalidTypePattern());
    }

    @Override
    public boolean supports(DatabaseProduct product) {
        return "H2".equals(product.getName());
    }

    private static class InvalidTypePattern
    extends PatternViolationResolver.ViolationPattern {
        public InvalidTypePattern() {
            super("Data conversion error converting \"'(.+)' \\((.+): (.+) (.+)\\)\"; SQL statement:\n(.*) \\[(.*)\\]");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.INVALID_TYPE).table(variables.get(2).toLowerCase()).column(variables.get(3).toLowerCase()).expectedValueType(variables.get(4).toLowerCase()).statement(variables.get(5).trim()).number(variables.get(6).trim()).build();
        }
    }

    private static class LengthPattern
    extends PatternViolationResolver.ViolationPattern {
        public LengthPattern() {
            super("Value too long for column \"(.+) (.+)\\((.+)\\).*\": \"'(.+)' \\((.+)\\)\"; SQL statement:\n(.*) \\[(.*)\\]");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.LENGTH_EXCEEDED).column(variables.get(1).toLowerCase()).valueType(variables.get(2).toLowerCase()).maximumLength(variables.get(3)).value(variables.get(4)).statement(variables.get(6).trim()).number(variables.get(7).trim()).build();
        }
    }

    private static class ForeignKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public ForeignKeyPattern() {
            super("Referential integrity constraint violation: \"(.+): (.+)\\.(.+) FOREIGN KEY\\((.+)\\) REFERENCES (.+)\\.(.+)\\((.+)\\) \\((.+)\\)\"; SQL statement:\n(.*) \\[(.*)\\]");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.FOREIGN_KEY).constraint(variables.get(1).toLowerCase()).table(variables.get(3).toLowerCase()).column(variables.get(4).toLowerCase()).referencingTable(variables.get(6).toLowerCase()).referencingColumn(variables.get(7).toLowerCase()).value(variables.get(8)).statement(variables.get(9).trim()).number(variables.get(10).trim()).build();
        }
    }

    private static class UniqueKeyPattern
    extends PatternViolationResolver.ViolationPattern {
        public UniqueKeyPattern() {
            super("Unique index or primary key violation: \"(\\w+)_INDEX_\\d+ ON (.+)\\.(.+)\\((.+)\\)\"; SQL statement:\n(.*) \\[(.*)\\]");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.UNIQUE_KEY).constraint(variables.get(1).toLowerCase()).table(variables.get(3).toLowerCase()).column(variables.get(4).toLowerCase()).statement(variables.get(5).trim()).number(variables.get(6).trim()).build();
        }
    }

    private static class NotNullPattern
    extends PatternViolationResolver.ViolationPattern {
        public NotNullPattern() {
            super("NULL not allowed for column \"(.+)\"; SQL statement:\n(.*) \\[(.*)\\]");
        }

        @Override
        public DatabaseConstraintViolation build(PatternViolationResolver.VariableAccessor variables) {
            return DatabaseConstraintViolation.builder(DatabaseConstraintType.NOT_NULL).column(variables.get(1).toLowerCase()).statement(variables.get(2).trim()).number(variables.get(3).trim()).build();
        }
    }
}

