/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver;

import java.util.Collection;
import java.util.LinkedList;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.DatabaseConstraintViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.DatabaseProductSpecific;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.DatabaseProduct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ViolationResolverChain
implements DatabaseConstraintViolationResolver {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final Collection<DatabaseConstraintViolationResolver> resolvers = new LinkedList<DatabaseConstraintViolationResolver>();

    @Override
    public DatabaseConstraintViolation resolve(Throwable throwable) {
        for (DatabaseConstraintViolationResolver resolver : this.resolvers) {
            this.logger.debug("Attempting to resolve violation with: {}", (Object)resolver);
            DatabaseConstraintViolation violation = resolver.resolve(throwable);
            if (violation == null) continue;
            this.logger.debug("Violation was resolved by: {}", (Object)resolver);
            return violation;
        }
        return null;
    }

    public ViolationResolverChain add(DatabaseConstraintViolationResolver resolver) {
        this.resolvers.add((DatabaseConstraintViolationResolver)Asserts.notNull((Object)resolver, (String)"Cannot add a null resolver to the chain."));
        this.logger.debug("Registered resolver {} to chain.", (Object)resolver);
        return this;
    }

    public ViolationResolverChain addIfSupported(DatabaseConstraintViolationResolver resolver, DatabaseProduct databaseProduct) {
        if (this.isSupported(resolver, databaseProduct)) {
            this.add(resolver);
        }
        return this;
    }

    private boolean isSupported(DatabaseConstraintViolationResolver resolver, DatabaseProduct databaseProduct) {
        boolean supported = true;
        if (resolver instanceof DatabaseProductSpecific) {
            supported = ((DatabaseProductSpecific)((Object)resolver)).supports(databaseProduct);
        }
        return supported;
    }
}

