/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver;

import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.DatabaseConstraintViolationResolver;
import org.jarbframework.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class RootCauseMessageViolationResolver
implements DatabaseConstraintViolationResolver {
    protected final Logger logger = LoggerFactory.getLogger(this.getClass());

    @Override
    public final DatabaseConstraintViolation resolve(Throwable throwable) {
        DatabaseConstraintViolation violation = null;
        String message = RootCauseMessageViolationResolver.getRootCause(throwable).getMessage();
        if (StringUtils.isNotBlank((String)message)) {
            this.logger.debug("Resolving violation based on message: {}", (Object)message);
            violation = this.resolve(message);
        }
        return violation;
    }

    public abstract DatabaseConstraintViolation resolve(String var1);

    private static Throwable getRootCause(Throwable throwable) {
        Throwable current = throwable;
        while (current.getCause() != null) {
            current = current.getCause();
        }
        return current;
    }
}

