/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver;

import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.RootCauseMessageViolationResolver;

public class PatternViolationResolver
extends RootCauseMessageViolationResolver {
    private final List<ViolationPattern> patterns = new LinkedList<ViolationPattern>();

    @Override
    public final DatabaseConstraintViolation resolve(String message) {
        ViolationPattern pattern;
        DatabaseConstraintViolation violation = null;
        Iterator<ViolationPattern> i$ = this.patterns.iterator();
        while (i$.hasNext() && (violation = (pattern = i$.next()).match(message)) == null) {
        }
        return violation;
    }

    protected void register(ViolationPattern pattern) {
        this.patterns.add(pattern);
    }

    protected static final class VariableAccessor {
        private final Matcher matcher;

        private VariableAccessor(Matcher matcher) {
            this.matcher = matcher;
        }

        public String get(int number) {
            return this.matcher.group(number);
        }
    }

    public static abstract class ViolationPattern {
        private final Pattern pattern;

        public ViolationPattern(String regex) {
            this.pattern = Pattern.compile(regex);
        }

        public DatabaseConstraintViolation match(String message) {
            DatabaseConstraintViolation violation = null;
            Matcher matcher = this.pattern.matcher(message);
            if (matcher.matches()) {
                violation = this.build(new VariableAccessor(matcher));
            }
            return violation;
        }

        public abstract DatabaseConstraintViolation build(VariableAccessor var1);
    }
}

