/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver;

import org.hibernate.exception.ConstraintViolationException;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.resolver.DatabaseConstraintViolationResolver;
import org.jarbframework.utils.Classes;

public class HibernateViolationResolver
implements DatabaseConstraintViolationResolver {
    private static final boolean HIBERNATE_ON_CLASSPATH = Classes.hasClass((String)"org.hibernate.exception.ConstraintViolationException");

    @Override
    public DatabaseConstraintViolation resolve(Throwable throwable) {
        DatabaseConstraintViolation violation = null;
        if (HIBERNATE_ON_CLASSPATH && throwable instanceof ConstraintViolationException) {
            String constraintName = ((ConstraintViolationException)throwable).getConstraintName();
            violation = new DatabaseConstraintViolation(constraintName);
        }
        return violation;
    }
}

