/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.resolver;

import java.util.Arrays;
import java.util.Collection;
import java.util.Set;
import javax.sql.DataSource;
import org.jarbframework.constraint.violation.resolver.DatabaseConstraintViolationResolver;
import org.jarbframework.constraint.violation.resolver.HibernateViolationResolver;
import org.jarbframework.constraint.violation.resolver.LazyInitViolationResolver;
import org.jarbframework.constraint.violation.resolver.ViolationResolverChain;
import org.jarbframework.constraint.violation.resolver.vendor.H2ViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.HsqlViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.MysqlViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.OracleViolationResolver;
import org.jarbframework.constraint.violation.resolver.vendor.PostgresViolationResolver;
import org.jarbframework.utils.ClassScanner;
import org.jarbframework.utils.DatabaseProduct;
import org.springframework.beans.BeanUtils;

public class ConfigurableViolationResolver
extends LazyInitViolationResolver {
    private final ViolationResolverChain resolvers = new ViolationResolverChain();
    private final DataSource dataSource;
    private final Collection<String> basePackages;

    public ConfigurableViolationResolver(DataSource dataSource, String basePackage) {
        this(dataSource, Arrays.asList(basePackage));
    }

    public ConfigurableViolationResolver(DataSource dataSource, Collection<String> basePackages) {
        this.dataSource = dataSource;
        this.basePackages = basePackages;
    }

    @Override
    protected DatabaseConstraintViolationResolver init() {
        DatabaseProduct product = DatabaseProduct.fromDataSource((DataSource)this.dataSource);
        this.registerCustomResolvers(product);
        this.registerDefaultResolvers(product);
        return this.resolvers;
    }

    public void registerResolver(DatabaseConstraintViolationResolver resolver) {
        this.resolvers.add(resolver);
    }

    private void registerCustomResolvers(DatabaseProduct databaseProduct) {
        for (String basePackage : this.basePackages) {
            Set resolverClasses = ClassScanner.getAllOfType((String)basePackage, DatabaseConstraintViolationResolver.class);
            for (Class resolverClass : resolverClasses) {
                this.resolvers.addIfSupported(this.newResolver(resolverClass), databaseProduct);
            }
        }
    }

    private DatabaseConstraintViolationResolver newResolver(Class<?> resolverClass) {
        return (DatabaseConstraintViolationResolver)BeanUtils.instantiateClass(resolverClass);
    }

    private void registerDefaultResolvers(DatabaseProduct product) {
        this.resolvers.addIfSupported(new H2ViolationResolver(), product);
        this.resolvers.addIfSupported(new HsqlViolationResolver(), product);
        this.resolvers.addIfSupported(new MysqlViolationResolver(), product);
        this.resolvers.addIfSupported(new OracleViolationResolver(), product);
        this.resolvers.addIfSupported(new PostgresViolationResolver(), product);
        this.resolvers.add(new HibernateViolationResolver());
    }
}

