/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.factory;

import java.lang.reflect.Constructor;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.factory.BeanBuilder;
import org.jarbframework.constraint.violation.factory.ConstructorFinder;
import org.jarbframework.constraint.violation.factory.DatabaseConstraintExceptionFactory;

public class ReflectionConstraintExceptionFactory
implements DatabaseConstraintExceptionFactory {
    private static final Class<?>[] SUPPORTED_PARAMETER_TYPES = new Class[]{DatabaseConstraintExceptionFactory.class, DatabaseConstraintViolation.class, Throwable.class};
    private final BeanBuilder<?> beanBuilder;

    public ReflectionConstraintExceptionFactory(Class<?> exceptionClass) {
        this(ConstructorFinder.findMostSupportedConstructor(exceptionClass, SUPPORTED_PARAMETER_TYPES));
    }

    public <T> ReflectionConstraintExceptionFactory(Constructor<T> constructor) {
        this.beanBuilder = new BeanBuilder<T>(constructor);
    }

    @Override
    public Throwable buildException(DatabaseConstraintViolation violation, Throwable cause) {
        Object bean = this.beanBuilder.instantiate(violation, cause, this);
        if (bean instanceof DatabaseConstraintExceptionFactory) {
            return ((DatabaseConstraintExceptionFactory)bean).buildException(violation, cause);
        }
        if (bean instanceof Throwable) {
            return (Throwable)bean;
        }
        throw new UnsupportedOperationException("Unable to create exception from: " + bean);
    }
}

