/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.factory;

public enum NameMatchingStrategy {
    EXACT{

        @Override
        public boolean matches(String expected, String actual) {
            return actual.equals(expected);
        }
    }
    ,
    EXACT_IGNORE_CASE{

        @Override
        public boolean matches(String expected, String actual) {
            return actual.equalsIgnoreCase(expected);
        }
    }
    ,
    STARTS_WITH{

        @Override
        public boolean matches(String expected, String actual) {
            return actual.startsWith(expected);
        }
    }
    ,
    ENDS_WITH{

        @Override
        public boolean matches(String expected, String actual) {
            return actual.endsWith(expected);
        }
    }
    ,
    CONTAINS{

        @Override
        public boolean matches(String expected, String actual) {
            return actual.contains(expected);
        }
    }
    ,
    REGEX{

        @Override
        public boolean matches(String expected, String actual) {
            return actual.matches(expected);
        }
    };


    public abstract boolean matches(String var1, String var2);
}

