/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.factory;

import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.factory.NameMatchingStrategy;
import org.jarbframework.constraint.violation.factory.ViolationPredicate;
import org.jarbframework.utils.StringUtils;

public class NameMatchingPredicate
implements ViolationPredicate {
    private final String expectedName;
    private final NameMatchingStrategy matchingStrategy;

    public NameMatchingPredicate(String constraintName, NameMatchingStrategy matchingStrategy) {
        this.expectedName = constraintName;
        this.matchingStrategy = matchingStrategy;
    }

    @Override
    public boolean isSupported(DatabaseConstraintViolation violation) {
        boolean matches = false;
        String actualName = violation.getConstraintName();
        if (StringUtils.isNotBlank((String)actualName)) {
            matches = this.matchingStrategy.matches(this.expectedName, actualName);
        }
        return matches;
    }
}

