/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.factory;

import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

final class ConstructorFinder {
    ConstructorFinder() {
    }

    public static <T> Constructor<T> findMostSupportedConstructor(Class<T> beanClass, Class<?>[] supportedTypes) {
        List<Constructor<?>> constructors = ConstructorFinder.getAllConstructorsSortedOnNumberOfArguments(beanClass);
        for (Constructor<?> constructor : constructors) {
            if (!ConstructorFinder.isSupportedConstructor(constructor, supportedTypes)) continue;
            return constructor;
        }
        throw new IllegalStateException("Could not find a supported constructor.");
    }

    private static <T> List<Constructor<?>> getAllConstructorsSortedOnNumberOfArguments(Class<T> beanClass) {
        ArrayList declaredConstructors = new ArrayList();
        declaredConstructors.addAll(Arrays.asList(beanClass.getDeclaredConstructors()));
        Collections.sort(declaredConstructors, new ConstructorParameterTypeLengthComparator());
        return declaredConstructors;
    }

    private static boolean isSupportedConstructor(Constructor<?> constructor, Class<?>[] supportedTypes) {
        boolean supported = true;
        for (Class<?> parameterType : constructor.getParameterTypes()) {
            if (ConstructorFinder.isSupportedParameterType(parameterType, supportedTypes)) continue;
            supported = false;
            break;
        }
        return supported;
    }

    private static boolean isSupportedParameterType(Class<?> parameterType, Class<?>[] supportedTypes) {
        boolean supported = false;
        for (Class<?> supportedType : supportedTypes) {
            if (!supportedType.isAssignableFrom(parameterType)) continue;
            supported = true;
            break;
        }
        return supported;
    }

    private static class ConstructorParameterTypeLengthComparator
    implements Comparator<Constructor<?>> {
        private ConstructorParameterTypeLengthComparator() {
        }

        @Override
        public int compare(Constructor<?> left, Constructor<?> right) {
            return this.numberOfParameterTypes(right).compareTo(this.numberOfParameterTypes(left));
        }

        private Integer numberOfParameterTypes(Constructor<?> constructor) {
            return constructor.getParameterTypes().length;
        }
    }
}

