/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation.factory;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.factory.DatabaseConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.DefaultConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.NameMatchingPredicate;
import org.jarbframework.constraint.violation.factory.NameMatchingStrategy;
import org.jarbframework.constraint.violation.factory.NamedConstraint;
import org.jarbframework.constraint.violation.factory.ReflectionConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.ViolationPredicate;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.ClassScanner;
import org.jarbframework.utils.StringUtils;
import org.springframework.core.annotation.AnnotationUtils;

public class ConfigurableConstraintExceptionFactory
implements DatabaseConstraintExceptionFactory {
    private final List<ExceptionFactoryMapping> exceptionFactoryMappings = new ArrayList<ExceptionFactoryMapping>();
    private final DatabaseConstraintExceptionFactory defaultExceptionFactory;

    public ConfigurableConstraintExceptionFactory() {
        this(new DefaultConstraintExceptionFactory());
    }

    public ConfigurableConstraintExceptionFactory(DatabaseConstraintExceptionFactory defaultExceptionFactory) {
        this.defaultExceptionFactory = defaultExceptionFactory;
    }

    @Override
    public Throwable buildException(DatabaseConstraintViolation violation, Throwable cause) {
        Asserts.notNull((Object)violation, (String)"Cannot create exception for a null database constraint violation.");
        return this.getFirstSupportedFactory(violation).buildException(violation, cause);
    }

    private DatabaseConstraintExceptionFactory getFirstSupportedFactory(DatabaseConstraintViolation violation) {
        DatabaseConstraintExceptionFactory exceptionFactory = this.defaultExceptionFactory;
        for (ExceptionFactoryMapping exceptionFactoryMapping : this.exceptionFactoryMappings) {
            if (!exceptionFactoryMapping.isSupported(violation)) continue;
            exceptionFactory = exceptionFactoryMapping.getExceptionFactory();
            break;
        }
        return exceptionFactory;
    }

    public ConfigurableConstraintExceptionFactory register(String constraintName, NameMatchingStrategy matchingStrategy, Class<?> exceptionClass) {
        return this.register(constraintName, matchingStrategy, new ReflectionConstraintExceptionFactory(exceptionClass));
    }

    public ConfigurableConstraintExceptionFactory register(String constraintName, NameMatchingStrategy matchingStrategy, DatabaseConstraintExceptionFactory exceptionFactory) {
        return this.register(new NameMatchingPredicate(constraintName, matchingStrategy), exceptionFactory);
    }

    public ConfigurableConstraintExceptionFactory register(ViolationPredicate predicate, DatabaseConstraintExceptionFactory exceptionFactory) {
        this.exceptionFactoryMappings.add(new ExceptionFactoryMapping(predicate, exceptionFactory));
        return this;
    }

    public ConfigurableConstraintExceptionFactory registerAll(String basePackage) {
        if (StringUtils.isNotBlank((String)basePackage)) {
            Set annotatedClasses = ClassScanner.getAllWithAnnotation((String)basePackage, NamedConstraint.class);
            for (Class annotatedClass : annotatedClasses) {
                NamedConstraint namedConstraint = (NamedConstraint)AnnotationUtils.findAnnotation((Class)annotatedClass, NamedConstraint.class);
                this.register(namedConstraint.value(), namedConstraint.strategy(), annotatedClass);
            }
        }
        return this;
    }

    private static class ExceptionFactoryMapping {
        private final ViolationPredicate predicate;
        private final DatabaseConstraintExceptionFactory exceptionFactory;

        public ExceptionFactoryMapping(ViolationPredicate predicate, DatabaseConstraintExceptionFactory exceptionFactory) {
            this.predicate = (ViolationPredicate)Asserts.notNull((Object)predicate, (String)"Violation predicate cannot be null.");
            this.exceptionFactory = (DatabaseConstraintExceptionFactory)Asserts.notNull((Object)exceptionFactory, (String)"Exception factory cannot be null.");
        }

        public boolean isSupported(DatabaseConstraintViolation violation) {
            return this.predicate.isSupported(violation);
        }

        public DatabaseConstraintExceptionFactory getExceptionFactory() {
            return this.exceptionFactory;
        }
    }
}

