/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation;

import java.lang.annotation.Annotation;
import org.aopalliance.aop.Advice;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.jarbframework.constraint.violation.AdvisorAddingBeanPostProcessor;
import org.jarbframework.constraint.violation.DatabaseConstraintExceptionTranslator;
import org.springframework.aop.Advisor;
import org.springframework.aop.Pointcut;
import org.springframework.aop.support.AbstractPointcutAdvisor;
import org.springframework.aop.support.annotation.AnnotationMatchingPointcut;
import org.springframework.stereotype.Repository;

public class TranslateExceptionsBeanPostProcessor
extends AdvisorAddingBeanPostProcessor {
    private final DatabaseConstraintExceptionTranslator translator;
    private final Pointcut pointcut;

    public TranslateExceptionsBeanPostProcessor(DatabaseConstraintExceptionTranslator translator) {
        this(translator, Repository.class);
    }

    public TranslateExceptionsBeanPostProcessor(DatabaseConstraintExceptionTranslator translator, Class<? extends Annotation> annotationClass) {
        this(translator, (Pointcut)new AnnotationMatchingPointcut(annotationClass, true));
    }

    public TranslateExceptionsBeanPostProcessor(DatabaseConstraintExceptionTranslator translator, Pointcut pointcut) {
        this.translator = translator;
        this.pointcut = pointcut;
        this.setAdvisor((Advisor)new ExceptionTranslatingAdvisor());
        this.setAddUpFront(true);
    }

    private class ExceptionTranslatingAdvisor
    extends AbstractPointcutAdvisor {
        private ExceptionTranslatingAdvisor() {
        }

        public Pointcut getPointcut() {
            return TranslateExceptionsBeanPostProcessor.this.pointcut;
        }

        public Advice getAdvice() {
            return new MethodInterceptor(){

                public Object invoke(MethodInvocation invocation) throws Throwable {
                    try {
                        return invocation.proceed();
                    }
                    catch (RuntimeException exception) {
                        throw this.translate(exception);
                    }
                }

                private Throwable translate(RuntimeException exception) {
                    Throwable translation = TranslateExceptionsBeanPostProcessor.this.translator.translate(exception);
                    return translation != null ? translation : exception;
                }
            };
        }
    }
}

