/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation;

import org.jarbframework.constraint.violation.DatabaseConstraintType;
import org.jarbframework.utils.StringUtils;

public final class DatabaseConstraintViolation {
    private final DatabaseConstraintType constraintType;
    private final String constraintName;
    private String tableName;
    private String columnName;
    private String referencingTableName;
    private String referencingColumnName;
    private Object value;
    private String valueType;
    private String expectedValueType;
    private Long maximumLength;
    private String statement;
    private String number;

    public DatabaseConstraintViolation(DatabaseConstraintType constraintType) {
        this(constraintType, null);
    }

    public DatabaseConstraintViolation(String constraintName) {
        this(null, constraintName);
    }

    public DatabaseConstraintViolation(DatabaseConstraintType constraintType, String constraintName) {
        if (constraintType == null && StringUtils.isBlank((String)constraintName)) {
            throw new IllegalArgumentException("Should provide a constraint type or name.");
        }
        this.constraintType = constraintType;
        this.constraintName = constraintName;
    }

    public static Builder builder(DatabaseConstraintType constraintType) {
        return new Builder(constraintType);
    }

    public DatabaseConstraintType getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName() {
        return this.columnName;
    }

    public String getReferencingTableName() {
        return this.referencingTableName;
    }

    public String getReferencingColumnName() {
        return this.referencingColumnName;
    }

    public Object getValue() {
        return this.value;
    }

    public String getValueType() {
        return this.valueType;
    }

    public String getExpectedValueType() {
        return this.expectedValueType;
    }

    public Long getMaximumLength() {
        return this.maximumLength;
    }

    public String getStatement() {
        return this.statement;
    }

    public String getNumber() {
        return this.number;
    }

    public String toString() {
        return (Object)((Object)this.constraintType) + ": " + this.constraintName;
    }

    public static final class Builder {
        private final DatabaseConstraintType constraintType;
        private String constraintName;
        private String tableName;
        private String columnName;
        private String referencingTableName;
        private String referencingColumnName;
        private Object value;
        private String valueType;
        private String expectedValueType;
        private Long maximumLength;
        private String statement;
        private String number;

        private Builder(DatabaseConstraintType constraintType) {
            this.constraintType = constraintType;
        }

        public Builder constraint(String constraintName) {
            this.constraintName = constraintName;
            return this;
        }

        public Builder table(String tableName) {
            this.tableName = tableName;
            return this;
        }

        public Builder column(String columnName) {
            this.columnName = columnName;
            return this;
        }

        public Builder referencingTable(String referencingTableName) {
            this.referencingTableName = referencingTableName;
            return this;
        }

        public Builder referencingColumn(String referencingColumnName) {
            this.referencingColumnName = referencingColumnName;
            return this;
        }

        public Builder value(Object value) {
            this.value = value;
            return this;
        }

        public Builder valueType(String valueType) {
            this.valueType = valueType;
            return this;
        }

        public Builder expectedValueType(String expectedValueType) {
            this.expectedValueType = expectedValueType;
            return this;
        }

        public Builder maximumLength(String maximumLength) {
            return this.maximumLength(Long.valueOf(maximumLength));
        }

        public Builder maximumLength(Long maximumLength) {
            this.maximumLength = maximumLength;
            return this;
        }

        public Builder statement(String statement) {
            this.statement = statement;
            return this;
        }

        public Builder number(String number) {
            this.number = number;
            return this;
        }

        public DatabaseConstraintViolation build() {
            DatabaseConstraintViolation violation = new DatabaseConstraintViolation(this.constraintType, this.constraintName);
            violation.tableName = this.tableName;
            violation.columnName = this.columnName;
            violation.referencingTableName = this.referencingTableName;
            violation.referencingColumnName = this.referencingColumnName;
            violation.value = this.value;
            violation.valueType = this.valueType;
            violation.expectedValueType = this.expectedValueType;
            violation.maximumLength = this.maximumLength;
            violation.statement = this.statement;
            violation.number = this.number;
            return violation;
        }
    }
}

