/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jarbframework.constraint.violation.DatabaseConstraintExceptionTranslator;
import org.jarbframework.constraint.violation.factory.ConfigurableConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.DatabaseConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.DefaultConstraintExceptionFactory;
import org.jarbframework.constraint.violation.resolver.ConfigurableViolationResolver;
import org.jarbframework.utils.orm.hibernate.HibernateUtils;
import org.jarbframework.utils.spring.SingletonFactoryBean;

public final class DatabaseConstraintExceptionTranslatorFactoryBean
extends SingletonFactoryBean<DatabaseConstraintExceptionTranslator> {
    private final DataSource dataSource;
    private String basePackage;
    private DatabaseConstraintExceptionFactory defaultExceptionFactory;

    public DatabaseConstraintExceptionTranslatorFactoryBean(DataSource dataSource) {
        this.dataSource = dataSource;
        this.defaultExceptionFactory = new DefaultConstraintExceptionFactory();
    }

    public DatabaseConstraintExceptionTranslatorFactoryBean(EntityManagerFactory entityManagerFactory) {
        this(HibernateUtils.getDataSource((EntityManagerFactory)entityManagerFactory));
    }

    protected DatabaseConstraintExceptionTranslator createObject() throws Exception {
        ConfigurableViolationResolver violationResolver = new ConfigurableViolationResolver(this.dataSource, this.basePackage);
        ConfigurableConstraintExceptionFactory exceptionFactory = new ConfigurableConstraintExceptionFactory(this.defaultExceptionFactory).registerAll(this.basePackage);
        return new DatabaseConstraintExceptionTranslator(violationResolver, exceptionFactory);
    }

    public void setBasePackage(String basePackage) {
        this.basePackage = basePackage;
    }

    public void setDefaultExceptionFactory(DatabaseConstraintExceptionFactory defaultExceptionFactory) {
        this.defaultExceptionFactory = defaultExceptionFactory;
    }
}

