/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.violation;

import org.jarbframework.constraint.violation.DatabaseConstraintViolation;
import org.jarbframework.constraint.violation.factory.DatabaseConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.DefaultConstraintExceptionFactory;
import org.jarbframework.constraint.violation.resolver.DatabaseConstraintViolationResolver;
import org.jarbframework.utils.Asserts;

public class DatabaseConstraintExceptionTranslator {
    private final DatabaseConstraintViolationResolver violationResolver;
    private final DatabaseConstraintExceptionFactory exceptionFactory;

    public DatabaseConstraintExceptionTranslator(DatabaseConstraintViolationResolver violationResolver) {
        this(violationResolver, new DefaultConstraintExceptionFactory());
    }

    public DatabaseConstraintExceptionTranslator(DatabaseConstraintViolationResolver violationResolver, DatabaseConstraintExceptionFactory exceptionFactory) {
        this.violationResolver = (DatabaseConstraintViolationResolver)Asserts.notNull((Object)violationResolver, (String)"Violation resolver cannot be null.");
        this.exceptionFactory = (DatabaseConstraintExceptionFactory)Asserts.notNull((Object)exceptionFactory, (String)"Exception factory cannot be null.");
    }

    public Throwable translate(Throwable throwable) {
        Throwable translation = null;
        DatabaseConstraintViolation violation = this.violationResolver.resolve(throwable);
        if (violation != null) {
            translation = this.exceptionFactory.buildException(violation, throwable);
        }
        return translation;
    }
}

