/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.validation;

import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintTarget;
import javax.validation.ConstraintValidator;
import javax.validation.MessageInterpolator;
import javax.validation.Payload;
import javax.validation.metadata.ConstraintDescriptor;

class ViolationMessageBuilder {
    private final MessageInterpolator messageInterpolator;

    public ViolationMessageBuilder(MessageInterpolator messageInterpolator) {
        this.messageInterpolator = messageInterpolator;
    }

    public ViolationMessageTemplate template(String templateName) {
        return new ViolationMessageTemplate(templateName);
    }

    private static class AttributeConstraintDescriptor
    implements ConstraintDescriptor<Annotation> {
        private final Map<String, Object> attributes;

        public AttributeConstraintDescriptor(Map<String, Object> attributes) {
            this.attributes = Collections.unmodifiableMap(attributes);
        }

        public Annotation getAnnotation() {
            return null;
        }

        public Map<String, Object> getAttributes() {
            return this.attributes;
        }

        public Set<ConstraintDescriptor<?>> getComposingConstraints() {
            return Collections.emptySet();
        }

        public List<Class<? extends ConstraintValidator<Annotation, ?>>> getConstraintValidatorClasses() {
            return Collections.emptyList();
        }

        public Set<Class<?>> getGroups() {
            return Collections.emptySet();
        }

        public Set<Class<? extends Payload>> getPayload() {
            return Collections.emptySet();
        }

        public boolean isReportAsSingleViolation() {
            return false;
        }

        public String getMessageTemplate() {
            return "";
        }

        public ConstraintTarget getValidationAppliesTo() {
            return null;
        }
    }

    private static class SimpleInterpolatorContext
    implements MessageInterpolator.Context {
        private final ConstraintDescriptor<?> constraintDescriptor;
        private final Object value;

        public SimpleInterpolatorContext(ConstraintDescriptor<?> constraintDescriptor, Object value) {
            this.constraintDescriptor = constraintDescriptor;
            this.value = value;
        }

        public ConstraintDescriptor<?> getConstraintDescriptor() {
            return this.constraintDescriptor;
        }

        public Object getValidatedValue() {
            return this.value;
        }

        public <T> T unwrap(Class<T> type) {
            if (type.isAssignableFrom(SimpleInterpolatorContext.class)) {
                return type.cast(this);
            }
            throw new UnsupportedOperationException();
        }
    }

    public class ViolationMessageTemplate {
        private final Map<String, Object> attributes;
        private final String templateName;
        private Object value;

        private ViolationMessageTemplate(String templateName) {
            this.templateName = templateName;
            this.attributes = new HashMap<String, Object>();
        }

        public ViolationMessageTemplate attribute(String attribute, Object value) {
            this.attributes.put(attribute, value);
            return this;
        }

        public ViolationMessageTemplate value(Object value) {
            this.value = value;
            return this;
        }

        public String message() {
            AttributeConstraintDescriptor descriptor = new AttributeConstraintDescriptor(this.attributes);
            return ViolationMessageBuilder.this.messageInterpolator.interpolate(this.templateName, (MessageInterpolator.Context)new SimpleInterpolatorContext(descriptor, this.value));
        }
    }
}

