/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.validation;

import org.jarbframework.constraint.metadata.DatabaseGenerated;
import org.jarbframework.constraint.metadata.database.ColumnMetadata;
import org.jarbframework.constraint.validation.DatabaseConstraintValidationStep;
import org.jarbframework.constraint.validation.DatabaseValidationContext;
import org.jarbframework.utils.bean.Annotations;
import org.jarbframework.utils.bean.PropertyReference;

public class NotNullConstraintValidationStep
implements DatabaseConstraintValidationStep {
    private static final String NOT_NULL_VIOLATION_TEMPLATE = "{javax.validation.constraints.NotNull.message}";

    @Override
    public void validate(Object value, PropertyReference reference, ColumnMetadata metadata, DatabaseValidationContext context) {
        if (value == null && this.isValueExpected(reference, metadata)) {
            context.buildViolationWithTemplate(reference, NOT_NULL_VIOLATION_TEMPLATE).addToContext();
        }
    }

    private boolean isValueExpected(PropertyReference reference, ColumnMetadata metadata) {
        return metadata.isRequired() && !this.isGeneratable(reference, metadata);
    }

    private boolean isGeneratable(PropertyReference reference, ColumnMetadata metadata) {
        return metadata.isGeneratable() || Annotations.hasAnnotation((PropertyReference)reference, DatabaseGenerated.class);
    }
}

