/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.validation;

import javax.validation.ConstraintValidatorContext;
import org.jarbframework.constraint.validation.ViolationMessageBuilder;
import org.jarbframework.utils.bean.PropertyReference;

final class DatabaseValidationContext {
    private final ConstraintValidatorContext context;
    private final ViolationMessageBuilder messageBuilder;
    private boolean valid = true;

    DatabaseValidationContext(ConstraintValidatorContext context, ViolationMessageBuilder messageBuilder) {
        this.context = context;
        this.messageBuilder = messageBuilder;
        context.disableDefaultConstraintViolation();
    }

    public boolean isValid() {
        return this.valid;
    }

    public ViolationBuilder buildViolationWithTemplate(PropertyReference propertyReference, String templateName) {
        return new ViolationBuilder(propertyReference, templateName);
    }

    public class ViolationBuilder {
        private final PropertyReference propertyReference;
        private ViolationMessageBuilder.ViolationMessageTemplate template;

        private ViolationBuilder(PropertyReference propertyReference, String templateName) {
            this.propertyReference = propertyReference;
            this.template = DatabaseValidationContext.this.messageBuilder.template(templateName);
        }

        public ViolationBuilder attribute(String attribute, Object value) {
            this.template.attribute(attribute, value);
            return this;
        }

        public ViolationBuilder value(Object value) {
            this.template.value(value);
            return this;
        }

        public DatabaseValidationContext addToContext() {
            this.markAsInvalid();
            ConstraintValidatorContext.ConstraintViolationBuilder builder = DatabaseValidationContext.this.context.buildConstraintViolationWithTemplate(this.template.message());
            this.addPropertyNode(builder).addConstraintViolation();
            return DatabaseValidationContext.this;
        }

        private void markAsInvalid() {
            DatabaseValidationContext.this.valid = false;
        }

        private ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext addPropertyNode(ConstraintValidatorContext.ConstraintViolationBuilder builder) {
            if (this.propertyReference.isNestedProperty()) {
                return builder.addPropertyNode(this.propertyReference.getPropertyName());
            }
            String[] path = this.propertyReference.getPath();
            ConstraintValidatorContext.ConstraintViolationBuilder.NodeBuilderCustomizableContext context = builder.addPropertyNode(path[0]);
            for (int i = 1; i < path.length; ++i) {
                context = context.addPropertyNode(path[i]);
            }
            return context;
        }
    }
}

