/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.validation;

import java.util.Map;
import javax.validation.ValidatorFactory;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.validation.DatabaseConstrained;
import org.jarbframework.constraint.validation.DatabaseConstraintValidator;
import org.jarbframework.utils.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.NoUniqueBeanDefinitionException;
import org.springframework.context.ApplicationContext;

public class DatabaseConstraintValidatorRegistry {
    private static final Logger LOGGER = LoggerFactory.getLogger(DatabaseConstraintValidatorRegistry.class);

    public static DatabaseConstraintValidator getValidator(ApplicationContext applicationContext, DatabaseConstrained annotation) {
        if (StringUtils.isNotBlank((String)annotation.id())) {
            return (DatabaseConstraintValidator)applicationContext.getBean(annotation.id(), DatabaseConstraintValidator.class);
        }
        LOGGER.info("Creating new DatabaseConstraintValidator because no @DatabaseConstrained.id is defined.");
        return DatabaseConstraintValidatorRegistry.buildValidator(applicationContext, annotation);
    }

    private static DatabaseConstraintValidator buildValidator(ApplicationContext applicationContext, DatabaseConstrained annotation) {
        BeanMetadataRepository beanMetadataRepository = DatabaseConstraintValidatorRegistry.getBean(applicationContext, annotation.beanMetadataRepository(), BeanMetadataRepository.class);
        ValidatorFactory validatorFactory = DatabaseConstraintValidatorRegistry.getBean(applicationContext, annotation.factory(), ValidatorFactory.class);
        return new DatabaseConstraintValidator(beanMetadataRepository, validatorFactory.getMessageInterpolator());
    }

    private static <T> T getBean(ApplicationContext applicationContext, String beanName, Class<T> beanClass) {
        if (StringUtils.isNotBlank((String)beanName)) {
            return (T)applicationContext.getBean(beanName, beanClass);
        }
        return DatabaseConstraintValidatorRegistry.getFirstBean(applicationContext, beanClass);
    }

    private static <T> T getFirstBean(ApplicationContext applicationContext, Class<T> beanClass) {
        try {
            return (T)applicationContext.getBean(beanClass);
        }
        catch (NoUniqueBeanDefinitionException nubde) {
            Map beans = applicationContext.getBeansOfType(beanClass, true, true);
            String firstBeanName = (String)beans.keySet().iterator().next();
            LOGGER.warn("Found multiple '{}' beans, using '{}' to create DatabaseConstraintValidator. Please define the desired bean in @DatabaseConstrained.", (Object)beanClass.getSimpleName(), (Object)firstBeanName);
            return (T)beans.get(firstBeanName);
        }
        catch (NoSuchBeanDefinitionException be) {
            throw new IllegalStateException("Missing required '" + beanClass.getSimpleName() + "' bean to create DatabaseConstraintValidator.", be);
        }
    }
}

