/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.validation;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.List;
import javax.validation.ConstraintValidatorContext;
import javax.validation.MessageInterpolator;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.metadata.database.ColumnMetadata;
import org.jarbframework.constraint.validation.DatabaseConstraintValidationStep;
import org.jarbframework.constraint.validation.DatabaseValidationContext;
import org.jarbframework.constraint.validation.FractionLengthConstraintValidationStep;
import org.jarbframework.constraint.validation.IgnoreDatabaseConstraints;
import org.jarbframework.constraint.validation.LengthConstraintValidationStep;
import org.jarbframework.constraint.validation.NotNullConstraintValidationStep;
import org.jarbframework.constraint.validation.ViolationMessageBuilder;
import org.jarbframework.utils.StringUtils;
import org.jarbframework.utils.bean.Beans;
import org.jarbframework.utils.bean.FlexibleBeanWrapper;
import org.jarbframework.utils.bean.PropertyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConstraintValidator {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final List<DatabaseConstraintValidationStep> validationSteps = new ArrayList<DatabaseConstraintValidationStep>();
    private BeanMetadataRepository beanMetadataRepository;
    private ViolationMessageBuilder messageBuilder;

    public DatabaseConstraintValidator(BeanMetadataRepository beanMetadataRepository, MessageInterpolator messageInterpolator) {
        this.validationSteps.add(new NotNullConstraintValidationStep());
        this.validationSteps.add(new LengthConstraintValidationStep());
        this.validationSteps.add(new FractionLengthConstraintValidationStep());
        this.beanMetadataRepository = beanMetadataRepository;
        this.messageBuilder = new ViolationMessageBuilder(messageInterpolator);
    }

    public boolean isValid(Object bean, Class<?> entityClass, String propertyName, ConstraintValidatorContext validatorContext) {
        DatabaseValidationContext validation = new DatabaseValidationContext(validatorContext, this.messageBuilder);
        this.validateBean(bean, new BasePath(entityClass, propertyName), validation);
        return validation.isValid();
    }

    private void validateBean(Object bean, BasePath basePath, DatabaseValidationContext validation) {
        FlexibleBeanWrapper beanWrapper = new FlexibleBeanWrapper(bean);
        for (String propertyName : Beans.getFieldNames(bean.getClass())) {
            this.validateProperty(beanWrapper, new PropertyReference(bean.getClass(), propertyName), basePath, validation);
        }
    }

    private void validateProperty(FlexibleBeanWrapper beanWrapper, PropertyReference propertyReference, BasePath basePath, DatabaseValidationContext validation) {
        Field field = Beans.findPropertyField((PropertyReference)propertyReference);
        if (this.isValidatable(field)) {
            Class<?> propertyClass = field.getType();
            if (this.beanMetadataRepository.isEmbeddable(propertyClass)) {
                for (String propertyName : Beans.getFieldNames(propertyClass)) {
                    this.validateProperty(beanWrapper, new PropertyReference(propertyReference, propertyName), basePath, validation);
                }
            } else {
                this.validateSimpleProperty(beanWrapper, propertyReference, basePath, validation);
            }
        }
    }

    private boolean isValidatable(Field field) {
        return !Modifier.isStatic(field.getModifiers()) && field.getAnnotation(IgnoreDatabaseConstraints.class) == null;
    }

    private void validateSimpleProperty(FlexibleBeanWrapper beanWrapper, PropertyReference propertyReference, BasePath basePath, DatabaseValidationContext validation) {
        PropertyReference wrappedPropertyReference = basePath.apply(propertyReference);
        ColumnMetadata columnMetadata = this.beanMetadataRepository.getColumnMetadata(wrappedPropertyReference);
        if (columnMetadata != null) {
            Object propertyValue = beanWrapper.getPropertyValue(propertyReference.getPropertyName());
            for (DatabaseConstraintValidationStep validationStep : this.validationSteps) {
                validationStep.validate(propertyValue, propertyReference, columnMetadata, validation);
            }
        } else {
            this.logger.debug("Skipped validation because no meta-data could be found for property '{}'.", (Object)wrappedPropertyReference);
        }
    }

    private static final class BasePath {
        private final Class<?> baseClass;
        private final String propertyName;

        BasePath(Class<?> baseClass, String propertyName) {
            this.baseClass = baseClass;
            this.propertyName = propertyName;
        }

        PropertyReference apply(PropertyReference propertyPath) {
            if (this.hasBaseClass()) {
                if (StringUtils.isNotBlank((String)this.propertyName)) {
                    PropertyReference parent = new PropertyReference(this.baseClass, this.propertyName);
                    return new PropertyReference(parent, propertyPath.getPropertyName());
                }
                return new PropertyReference(this.baseClass, propertyPath.getPropertyName());
            }
            return propertyPath;
        }

        private boolean hasBaseClass() {
            return !Object.class.equals(this.baseClass);
        }
    }
}

