/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import java.lang.annotation.Annotation;
import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.types.PropertyType;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.Annotations;
import org.jarbframework.utils.bean.PropertyReference;

public class PropertyTypeEnhancer
implements PropertyConstraintEnhancer {
    private final Class<? extends Annotation> annotationClass;

    public PropertyTypeEnhancer() {
        this(PropertyType.class);
    }

    public PropertyTypeEnhancer(Class<? extends Annotation> annotationClass) {
        this.annotationClass = (Class)Asserts.notNull(annotationClass, (String)"Annotation class cannot be null");
    }

    @Override
    public void enhance(PropertyConstraintDescription description) {
        if (Annotations.hasAnnotation((PropertyReference)description.toReference(), this.annotationClass)) {
            Annotation annotation = (Annotation)Annotations.getAnnotations((PropertyReference)description.toReference(), this.annotationClass).iterator().next();
            if (annotation instanceof PropertyType) {
                description.addType(((PropertyType)annotation).value());
            } else {
                PropertyType customType = annotation.annotationType().getAnnotation(PropertyType.class);
                if (customType != null) {
                    description.addType(customType.value());
                }
            }
        }
    }
}

