/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.springframework.util.Assert;

public class MinMaxNumberPropertyEnhancer
implements PropertyConstraintEnhancer {
    private final Class<?> propertyType;
    private final long minValue;
    private final long maxValue;

    public MinMaxNumberPropertyEnhancer(Class<?> propertyType, long minValue, long maxValue) {
        Assert.state((boolean)Number.class.isAssignableFrom(propertyType), (String)"Property type must be a number.");
        this.propertyType = propertyType;
        this.minValue = minValue;
        this.maxValue = maxValue;
    }

    @Override
    public void enhance(PropertyConstraintDescription description) {
        if (this.propertyType.equals(description.getJavaType())) {
            description.addMin(this.minValue);
            description.addMax(this.maxValue);
        }
    }
}

