/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import java.util.Collection;
import org.hibernate.validator.constraints.Length;
import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.utils.bean.Annotations;
import org.jarbframework.utils.bean.PropertyReference;

public class LengthPropertyConstraintEnhancer
implements PropertyConstraintEnhancer {
    @Override
    public void enhance(PropertyConstraintDescription description) {
        Collection annotations = Annotations.getAnnotations((PropertyReference)description.toReference(), Length.class);
        Integer minimumLength = description.getMinimumLength();
        Integer maximumLength = description.getMaximumLength();
        for (Length annotation : annotations) {
            minimumLength = this.highest(minimumLength, annotation.min());
            maximumLength = this.lowest(maximumLength, annotation.max());
        }
        description.setMinimumLength(minimumLength);
        description.setMaximumLength(maximumLength);
    }

    private Integer lowest(Integer current, Integer next) {
        return current != null ? Math.min(current, next) : next;
    }

    private Integer highest(Integer current, Integer next) {
        return current != null ? Math.max(current, next) : next;
    }
}

