/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import java.util.Collection;
import javax.validation.constraints.Digits;
import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.utils.bean.Annotations;
import org.jarbframework.utils.bean.PropertyReference;

public class DigitsPropertyConstraintEnhancer
implements PropertyConstraintEnhancer {
    @Override
    public void enhance(PropertyConstraintDescription description) {
        Collection annotations = Annotations.getAnnotations((PropertyReference)description.toReference(), Digits.class);
        Integer maximumLength = description.getMaximumLength();
        Integer fractionLength = description.getFractionLength();
        for (Digits annotation : annotations) {
            maximumLength = this.lowest(maximumLength, annotation.integer());
            fractionLength = this.lowest(fractionLength, annotation.fraction());
        }
        description.setMaximumLength(maximumLength);
        description.setFractionLength(fractionLength);
    }

    private Integer lowest(Integer current, int next) {
        return current != null ? Math.min(current, next) : next;
    }
}

