/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.metadata.database.ColumnMetadata;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.PropertyReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabasePropertyConstraintEnhancer
implements PropertyConstraintEnhancer {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    private final BeanMetadataRepository beanMetadataRepository;

    public DatabasePropertyConstraintEnhancer(BeanMetadataRepository beanMetadataRepository) {
        this.beanMetadataRepository = (BeanMetadataRepository)Asserts.notNull((Object)beanMetadataRepository, (String)"Bean metadata repository cannot be null");
    }

    @Override
    public void enhance(PropertyConstraintDescription description) {
        if (!this.beanMetadataRepository.isEmbeddable(description.getJavaType())) {
            PropertyReference reference = description.toReference();
            ColumnMetadata metadata = this.beanMetadataRepository.getColumnMetadata(reference);
            if (metadata != null) {
                this.doEnhance(description, metadata);
            } else {
                this.logger.debug("Could not resolve column metadata for '{}'.", (Object)reference);
            }
        }
    }

    private void doEnhance(PropertyConstraintDescription description, ColumnMetadata metadata) {
        description.setRequired(this.isValueRequired(metadata));
        description.setMaximumLength(metadata.getMaximumLength());
        description.setFractionLength(metadata.getFractionLength());
        description.setRadix(metadata.getRadix());
    }

    private boolean isValueRequired(ColumnMetadata columnMetadata) {
        return columnMetadata.isRequired() && !columnMetadata.isGeneratable();
    }
}

