/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.utils.Asserts;

public class ClassPropertyTypeEnhancer
implements PropertyConstraintEnhancer {
    private final Class<?> propertyClass;
    private final String typeName;

    public ClassPropertyTypeEnhancer(Class<?> propertyClass, String typeName) {
        this.propertyClass = (Class)Asserts.notNull(propertyClass, (String)"Property class cannot be null");
        this.typeName = Asserts.hasText((String)typeName, (String)"Type name should have text");
    }

    @Override
    public void enhance(PropertyConstraintDescription description) {
        if (this.propertyClass.isAssignableFrom(description.getJavaType())) {
            description.addType(this.typeName);
        }
    }
}

