/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.enhance;

import java.lang.annotation.Annotation;
import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.Annotations;
import org.jarbframework.utils.bean.PropertyReference;

public class AnnotationPropertyTypeEnhancer
implements PropertyConstraintEnhancer {
    private final Class<? extends Annotation> annotationClass;
    private final String typeName;

    public AnnotationPropertyTypeEnhancer(Class<? extends Annotation> annotationClass, String typeName) {
        this.annotationClass = (Class)Asserts.notNull(annotationClass, (String)"Annotation class cannot be null");
        this.typeName = Asserts.hasText((String)typeName, (String)"Type name needs to have text");
    }

    @Override
    public void enhance(PropertyConstraintDescription description) {
        if (Annotations.hasAnnotation((PropertyReference)description.toReference(), this.annotationClass)) {
            description.addType(this.typeName);
        }
    }
}

