/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.database;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.jarbframework.constraint.metadata.database.ColumnMetadata;
import org.jarbframework.constraint.metadata.database.ColumnMetadataRepository;
import org.jarbframework.utils.JdbcConnectionCallback;
import org.jarbframework.utils.JdbcUtils;
import org.jarbframework.utils.StringUtils;
import org.jarbframework.utils.orm.ColumnReference;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JdbcColumnMetadataRepository
implements ColumnMetadataRepository {
    private final Logger logger = LoggerFactory.getLogger(JdbcColumnMetadataRepository.class);
    private final DataSource dataSource;
    private DatabaseIdentifierCaser identifierCaser;
    private String catalog;
    private String schema;

    public JdbcColumnMetadataRepository(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    @Override
    public ColumnMetadata getMetadata(final ColumnReference columnReference) {
        return (ColumnMetadata)JdbcUtils.doWithConnection((DataSource)this.dataSource, (JdbcConnectionCallback)new JdbcConnectionCallback<ColumnMetadata>(){

            public ColumnMetadata doWork(Connection connection) throws SQLException {
                DatabaseMetaData databaseMetaData = connection.getMetaData();
                if (JdbcColumnMetadataRepository.this.identifierCaser == null) {
                    JdbcColumnMetadataRepository.this.identifierCaser = new DatabaseIdentifierCaser(databaseMetaData);
                }
                String tableName = JdbcColumnMetadataRepository.this.identifierCaser.apply(columnReference.getTableName());
                String columnName = JdbcColumnMetadataRepository.this.identifierCaser.apply(columnReference.getColumnName());
                JdbcColumnMetadataRepository.this.logger.debug("Querying column metadata for table: {}, column: {}.", (Object)tableName, (Object)columnName);
                ResultSet resultSet = databaseMetaData.getColumns(JdbcColumnMetadataRepository.this.catalog, JdbcColumnMetadataRepository.this.schema, tableName, columnName);
                return JdbcColumnMetadataRepository.this.mapToColumnMetadata(columnReference, resultSet);
            }
        });
    }

    private ColumnMetadata mapToColumnMetadata(ColumnReference columnReference, ResultSet resultSet) throws SQLException {
        ColumnMetadata columnMetadata = null;
        if (resultSet.next()) {
            Integer fractionLength;
            columnMetadata = new ColumnMetadata(columnReference);
            columnMetadata.setDefaultValue(resultSet.getString("COLUMN_DEF"));
            Integer columnSize = this.getValueAsInteger(resultSet, "COLUMN_SIZE");
            if (columnSize != null && columnSize > 0) {
                columnMetadata.setMaximumLength(columnSize);
            }
            if ((fractionLength = this.getValueAsInteger(resultSet, "DECIMAL_DIGITS")) != null) {
                columnMetadata.setFractionLength(Math.max(fractionLength, 0));
            }
            columnMetadata.setRadix(this.getValueAsInteger(resultSet, "NUM_PREC_RADIX"));
            columnMetadata.setRequired("NO".equals(this.getOptionalValue(resultSet, "IS_NULLABLE")));
            columnMetadata.setAutoIncrement("YES".equals(this.getOptionalValue(resultSet, "IS_AUTOINCREMENT")));
        }
        return columnMetadata;
    }

    private Integer getValueAsInteger(ResultSet resultSet, String columnLabel) throws SQLException {
        Integer value = null;
        String numberAsString = resultSet.getString(columnLabel);
        if (StringUtils.isNotBlank((String)numberAsString)) {
            value = Integer.parseInt(numberAsString);
        }
        return value;
    }

    private Object getOptionalValue(ResultSet resultSet, String columnLabel) {
        Object value = null;
        try {
            value = resultSet.getObject(columnLabel);
        }
        catch (SQLException e) {
            this.logger.trace("Column '" + columnLabel + "'  value could not be extracted from result set", (Throwable)e);
        }
        return value;
    }

    public void setCatalog(String catalog) {
        this.catalog = catalog;
    }

    public void setSchema(String schema) {
        this.schema = schema;
    }

    private static class DatabaseIdentifierCaser {
        private final String quoteString;
        private final boolean storeUpperCase;
        private final boolean storeUpperCaseQuoted;
        private final boolean storeLowerCase;
        private final boolean storeLowerCaseQuoted;

        public DatabaseIdentifierCaser(DatabaseMetaData databaseMetaData) throws SQLException {
            this.quoteString = databaseMetaData.getIdentifierQuoteString();
            this.storeUpperCase = databaseMetaData.storesUpperCaseIdentifiers();
            this.storeUpperCaseQuoted = databaseMetaData.storesUpperCaseQuotedIdentifiers();
            this.storeLowerCase = databaseMetaData.storesLowerCaseIdentifiers();
            this.storeLowerCaseQuoted = databaseMetaData.storesLowerCaseQuotedIdentifiers();
        }

        public String apply(String identifier) {
            if (this.isQuoted(identifier)) {
                identifier = this.applyQuoted(identifier);
            } else if (this.storeLowerCase) {
                identifier = identifier.toLowerCase();
            } else if (this.storeUpperCase) {
                identifier = identifier.toUpperCase();
            }
            return identifier;
        }

        private boolean isQuoted(String identifier) {
            boolean quoted = false;
            if (StringUtils.isNotBlank((String)this.quoteString)) {
                quoted = identifier.startsWith(this.quoteString) && identifier.endsWith(this.quoteString);
            }
            return quoted;
        }

        private String applyQuoted(String identifier) {
            int startIndex = this.quoteString.length();
            int endIndex = identifier.length() - startIndex;
            String unquotedIdentifier = identifier.substring(startIndex, endIndex);
            if (this.storeLowerCaseQuoted) {
                unquotedIdentifier = unquotedIdentifier.toLowerCase();
            } else if (this.storeUpperCaseQuoted) {
                unquotedIdentifier = unquotedIdentifier.toUpperCase();
            }
            return unquotedIdentifier;
        }
    }
}

