/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.database;

import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.orm.ColumnReference;

public class ColumnMetadata {
    private final ColumnReference columnReference;
    private boolean required;
    private boolean autoIncrement;
    private String defaultValue;
    private Integer maximumLength;
    private Integer radix;
    private Integer fractionLength;

    public ColumnMetadata(ColumnReference columnReference) {
        this.columnReference = (ColumnReference)Asserts.notNull((Object)columnReference, (String)"Column reference cannot be null");
    }

    public ColumnReference getColumnReference() {
        return this.columnReference;
    }

    public String getTableName() {
        return this.columnReference.getTableName();
    }

    public String getColumnName() {
        return this.columnReference.getColumnName();
    }

    public boolean isRequired() {
        return this.required;
    }

    public void setRequired(boolean required) {
        this.required = required;
    }

    public boolean isAutoIncrement() {
        return this.autoIncrement;
    }

    public void setAutoIncrement(boolean autoIncrement) {
        this.autoIncrement = autoIncrement;
    }

    public boolean isGeneratable() {
        return this.hasDefaultValue() || this.isAutoIncrement();
    }

    public boolean hasDefaultValue() {
        return this.defaultValue != null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(String defaultValue) {
        this.defaultValue = defaultValue;
    }

    public boolean hasMaximumLength() {
        return this.maximumLength != null;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public void setMaximumLength(Integer maximumLength) {
        this.maximumLength = maximumLength;
    }

    public Integer getRadix() {
        return this.radix;
    }

    public void setRadix(Integer radix) {
        this.radix = radix;
    }

    public boolean hasFractionLength() {
        return this.fractionLength != null;
    }

    public Integer getFractionLength() {
        return this.fractionLength;
    }

    public void setFractionLength(Integer fractionLength) {
        this.fractionLength = fractionLength;
    }

    public boolean equals(Object obj) {
        boolean equals = false;
        if (obj instanceof ColumnMetadata) {
            equals = this.columnReference.equals((Object)((ColumnMetadata)obj).getColumnReference());
        }
        return equals;
    }

    public int hashCode() {
        return this.columnReference.hashCode();
    }

    public String toString() {
        return this.columnReference.toString();
    }
}

