/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.database;

import java.util.HashMap;
import java.util.Map;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.metadata.database.ColumnMetadata;
import org.jarbframework.utils.bean.PropertyReference;

public class CachingBeanMetadataRepository
implements BeanMetadataRepository {
    private final Map<PropertyReference, ColumnMetadata> caches = new HashMap<PropertyReference, ColumnMetadata>();
    private final BeanMetadataRepository delegate;

    public CachingBeanMetadataRepository(BeanMetadataRepository delegate) {
        this.delegate = delegate;
    }

    @Override
    public ColumnMetadata getColumnMetadata(PropertyReference propertyReference) {
        ColumnMetadata columnMetadata = this.caches.get(propertyReference);
        if (columnMetadata == null) {
            columnMetadata = this.delegate.getColumnMetadata(propertyReference);
            this.caches.put(propertyReference, columnMetadata);
        }
        return columnMetadata;
    }

    @Override
    public boolean isEmbeddable(Class<?> propertyType) {
        return this.delegate.isEmbeddable(propertyType);
    }

    public void evictAll() {
        this.caches.clear();
    }
}

