/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata.database;

import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.metadata.database.CachingBeanMetadataRepository;
import org.jarbframework.constraint.metadata.database.ColumnMetadataRepository;
import org.jarbframework.constraint.metadata.database.JdbcColumnMetadataRepository;
import org.jarbframework.constraint.metadata.database.SimpleBeanMetadataRepository;
import org.jarbframework.utils.orm.JdbcSchemaMapper;
import org.jarbframework.utils.orm.SchemaMapper;
import org.jarbframework.utils.orm.hibernate.HibernateJpaSchemaMapper;
import org.jarbframework.utils.orm.hibernate.HibernateUtils;
import org.jarbframework.utils.spring.SingletonFactoryBean;

public class BeanMetadataRepositoryFactoryBean
extends SingletonFactoryBean<BeanMetadataRepository> {
    private final ColumnMetadataRepository columnMetadataRepository;
    private final SchemaMapper schemaMapper;

    public BeanMetadataRepositoryFactoryBean(EntityManagerFactory entityManagerFactory) {
        DataSource dataSource = HibernateUtils.getDataSource((EntityManagerFactory)entityManagerFactory);
        this.columnMetadataRepository = new JdbcColumnMetadataRepository(dataSource);
        this.schemaMapper = new HibernateJpaSchemaMapper(entityManagerFactory);
    }

    public BeanMetadataRepositoryFactoryBean(DataSource dataSource) {
        this.columnMetadataRepository = new JdbcColumnMetadataRepository(dataSource);
        this.schemaMapper = new JdbcSchemaMapper();
    }

    protected BeanMetadataRepository createObject() throws Exception {
        SimpleBeanMetadataRepository beanMetadataRepository = new SimpleBeanMetadataRepository(this.columnMetadataRepository, this.schemaMapper);
        return new CachingBeanMetadataRepository(beanMetadataRepository);
    }
}

