/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata;

import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.PropertyReference;

public class PropertyConstraintDescription {
    private final PropertyReference reference;
    private final Class<?> javaType;
    private final Set<String> types = new LinkedHashSet<String>();
    private boolean required;
    private Integer minimumLength;
    private Integer maximumLength;
    private Integer fractionLength;
    private Integer radix;
    private String pattern;
    private Object min;
    private Object max;

    public PropertyConstraintDescription(PropertyReference reference, Class<?> javaType) {
        this.reference = (PropertyReference)Asserts.notNull((Object)reference, (String)"Reference cannot be null.");
        this.javaType = (Class)Asserts.notNull(javaType, (String)("Java type of '" + reference.toString() + "' cannot be null."));
    }

    public String getName() {
        return this.reference.getPropertyName();
    }

    public Class<?> getJavaType() {
        return this.javaType;
    }

    public Set<String> getTypes() {
        return Collections.unmodifiableSet(this.types);
    }

    public PropertyConstraintDescription addType(String type) {
        this.types.add(type);
        return this;
    }

    public boolean isRequired() {
        return this.required;
    }

    public PropertyConstraintDescription setRequired(boolean required) {
        this.required = required;
        return this;
    }

    public Integer getMinimumLength() {
        return this.minimumLength;
    }

    public PropertyConstraintDescription setMinimumLength(Integer minimumLength) {
        if (minimumLength != null && minimumLength < 0) {
            throw new IllegalStateException("Minimum length cannot be negative.");
        }
        if (!this.isRange(minimumLength, this.maximumLength)) {
            String message = String.format("Cannot change minimum length to '%d', as the maximum length '%d' is lower.", minimumLength, this.maximumLength);
            throw new IllegalStateException(message);
        }
        this.minimumLength = minimumLength;
        return this;
    }

    public Integer getMaximumLength() {
        return this.maximumLength;
    }

    public PropertyConstraintDescription setMaximumLength(Integer maximumLength) {
        if (maximumLength != null && maximumLength < 0) {
            throw new IllegalStateException("Maximum length cannot be negative.");
        }
        if (!this.isRange(this.minimumLength, maximumLength)) {
            String message = String.format("Cannot change maximum length to '%d', as the minimum length '%d' is greater.", maximumLength, this.minimumLength);
            throw new IllegalStateException(message);
        }
        this.maximumLength = maximumLength;
        return this;
    }

    private boolean isRange(Integer start, Integer end) {
        return start == null || end == null || end >= start;
    }

    public Integer getFractionLength() {
        return this.fractionLength;
    }

    public PropertyConstraintDescription setFractionLength(Integer fractionLength) {
        if (fractionLength != null && fractionLength < 0) {
            throw new IllegalStateException("Fraction length cannot be negative.");
        }
        this.fractionLength = fractionLength;
        return this;
    }

    public Integer getRadix() {
        return this.radix;
    }

    public PropertyConstraintDescription setRadix(Integer radix) {
        this.radix = radix;
        return this;
    }

    public String getPattern() {
        return this.pattern;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public Object getMin() {
        return this.min;
    }

    public void setMin(Object min) {
        this.min = min;
    }

    public Object getMax() {
        return this.max;
    }

    public void setMax(Object max) {
        this.max = max;
    }

    public PropertyReference toReference() {
        return this.reference;
    }

    public void addMin(long min) {
        if (this.min == null || ((Number)this.min).longValue() < min) {
            this.min = min;
        }
    }

    public void addMax(long max) {
        if (this.max == null || ((Number)this.max).longValue() > max) {
            this.max = max;
        }
    }

    public String toString() {
        return this.reference.toString();
    }
}

