/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata;

import java.util.Date;
import org.hibernate.validator.constraints.CreditCardNumber;
import org.jarbframework.constraint.metadata.BeanConstraintDescriptor;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.metadata.enhance.AnnotationPropertyTypeEnhancer;
import org.jarbframework.constraint.metadata.enhance.ClassPropertyTypeEnhancer;
import org.jarbframework.constraint.metadata.enhance.DatabaseGeneratedPropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.DatabasePropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.DigitsPropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.LengthPropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.MinMaxNumberAnnotationPropertyEnhancer;
import org.jarbframework.constraint.metadata.enhance.MinMaxNumberPropertyEnhancer;
import org.jarbframework.constraint.metadata.enhance.NotEmptyPropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.NotNullPropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.PatternPropertyConstraintEnhancer;
import org.jarbframework.constraint.metadata.enhance.PropertyTypeEnhancer;
import org.jarbframework.constraint.metadata.types.Color;
import org.jarbframework.constraint.metadata.types.Currency;
import org.jarbframework.constraint.metadata.types.Email;
import org.jarbframework.constraint.metadata.types.Password;
import org.jarbframework.constraint.metadata.types.Percentage;
import org.jarbframework.constraint.metadata.types.Phone;
import org.jarbframework.constraint.metadata.types.PropertyType;
import org.jarbframework.constraint.metadata.types.URL;
import org.jarbframework.utils.Classes;
import org.joda.time.DateTime;
import org.joda.time.LocalDate;
import org.joda.time.LocalDateTime;

public class DefaultBeanConstraintDescriptor
extends BeanConstraintDescriptor {
    private static final String JAVAX_VALIDATION_PACKAGE = "javax.validation";
    private static final String HIBERNATE_VALIDATION_PACKAGE = "org.hibernate.validator";
    private static final String JODA_TIME_PACKAGE = "org.joda.time";

    public DefaultBeanConstraintDescriptor(BeanMetadataRepository beanMetadataRepository) {
        this.registerDefaultEnhancers();
        if (Classes.hasPackage((String)JAVAX_VALIDATION_PACKAGE)) {
            this.registerJavaxValidationEnhancers();
        }
        if (Classes.hasPackage((String)HIBERNATE_VALIDATION_PACKAGE)) {
            this.registerHibernateValidationEnhancers();
        }
        if (Classes.hasClass((String)JODA_TIME_PACKAGE)) {
            this.registerJodaTimeEnhancers();
        }
        if (beanMetadataRepository != null) {
            this.registerDatabaseEnhancers(beanMetadataRepository);
        }
    }

    private void registerDefaultEnhancers() {
        this.registerEnhancer(new ClassPropertyTypeEnhancer(String.class, "text"));
        this.registerEnhancer(new ClassPropertyTypeEnhancer(Date.class, "date"));
        this.registerEnhancer(new ClassPropertyTypeEnhancer(Number.class, "number"));
        this.registerEnhancer(new PropertyTypeEnhancer(PropertyType.class));
        this.registerEnhancer(new PropertyTypeEnhancer(Color.class));
        this.registerEnhancer(new PropertyTypeEnhancer(Currency.class));
        this.registerEnhancer(new PropertyTypeEnhancer(Email.class));
        this.registerEnhancer(new PropertyTypeEnhancer(Password.class));
        this.registerEnhancer(new PropertyTypeEnhancer(Percentage.class));
        this.registerEnhancer(new PropertyTypeEnhancer(Phone.class));
        this.registerEnhancer(new PropertyTypeEnhancer(URL.class));
        this.registerEnhancer(new MinMaxNumberPropertyEnhancer(Byte.class, -128L, 127L));
        this.registerEnhancer(new MinMaxNumberPropertyEnhancer(Short.class, -32768L, 32767L));
        this.registerEnhancer(new MinMaxNumberPropertyEnhancer(Integer.class, Integer.MIN_VALUE, Integer.MAX_VALUE));
        this.registerEnhancer(new MinMaxNumberPropertyEnhancer(Long.class, Long.MIN_VALUE, Long.MAX_VALUE));
    }

    private void registerJavaxValidationEnhancers() {
        this.registerEnhancer(new NotNullPropertyConstraintEnhancer());
        this.registerEnhancer(new PatternPropertyConstraintEnhancer());
        this.registerEnhancer(new DigitsPropertyConstraintEnhancer());
        this.registerEnhancer(new MinMaxNumberAnnotationPropertyEnhancer());
    }

    private void registerHibernateValidationEnhancers() {
        this.registerEnhancer(new LengthPropertyConstraintEnhancer());
        this.registerEnhancer(new NotEmptyPropertyConstraintEnhancer());
        this.registerEnhancer(new AnnotationPropertyTypeEnhancer(org.hibernate.validator.constraints.Email.class, "email"));
        this.registerEnhancer(new AnnotationPropertyTypeEnhancer(CreditCardNumber.class, "credid_card"));
        this.registerEnhancer(new AnnotationPropertyTypeEnhancer(org.hibernate.validator.constraints.URL.class, "url"));
    }

    private void registerJodaTimeEnhancers() {
        this.registerEnhancer(new ClassPropertyTypeEnhancer(DateTime.class, "date-time"));
        this.registerEnhancer(new ClassPropertyTypeEnhancer(LocalDate.class, "date"));
        this.registerEnhancer(new ClassPropertyTypeEnhancer(LocalDateTime.class, "date-time-local"));
    }

    private void registerDatabaseEnhancers(BeanMetadataRepository beanMetadataRepository) {
        this.registerEnhancer(new DatabasePropertyConstraintEnhancer(beanMetadataRepository));
        this.registerEnhancer(new DatabaseGeneratedPropertyConstraintEnhancer());
    }
}

