/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint.metadata;

import java.beans.PropertyDescriptor;
import java.util.ArrayList;
import java.util.List;
import org.jarbframework.constraint.metadata.BeanConstraintDescription;
import org.jarbframework.constraint.metadata.PropertyConstraintDescription;
import org.jarbframework.constraint.metadata.enhance.PropertyConstraintEnhancer;
import org.jarbframework.utils.Asserts;
import org.jarbframework.utils.bean.PropertyReference;
import org.springframework.beans.BeanUtils;

public class BeanConstraintDescriptor {
    private final List<PropertyConstraintEnhancer> enhancers = new ArrayList<PropertyConstraintEnhancer>();

    public BeanConstraintDescription describe(Class<?> beanClass) {
        BeanConstraintDescription beanDescription = new BeanConstraintDescription(beanClass);
        for (PropertyDescriptor propertyDescriptor : BeanUtils.getPropertyDescriptors(beanClass)) {
            if (propertyDescriptor.getPropertyType() == null) continue;
            beanDescription.addProperty(this.describeProperty(beanClass, propertyDescriptor));
        }
        return beanDescription;
    }

    private PropertyConstraintDescription describeProperty(Class<?> beanClass, PropertyDescriptor descriptor) {
        PropertyConstraintDescription description = this.newPropertyDescription(beanClass, descriptor);
        for (PropertyConstraintEnhancer enhancer : this.enhancers) {
            enhancer.enhance(description);
        }
        return description;
    }

    private PropertyConstraintDescription newPropertyDescription(Class<?> beanClass, PropertyDescriptor descriptor) {
        PropertyReference reference = new PropertyReference(beanClass, descriptor.getName());
        return new PropertyConstraintDescription(reference, descriptor.getPropertyType());
    }

    public BeanConstraintDescriptor registerEnhancer(PropertyConstraintEnhancer enhancer) {
        this.enhancers.add((PropertyConstraintEnhancer)Asserts.notNull((Object)enhancer, (String)"Cannot add a null property constraint enhancer"));
        return this;
    }
}

