/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint;

import org.jarbframework.constraint.metadata.DefaultBeanConstraintDescriptor;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepositoryFactoryBean;
import org.jarbframework.constraint.violation.DatabaseConstraintExceptionTranslatorFactoryBean;
import org.jarbframework.constraint.violation.TranslateExceptionsBeanPostProcessor;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.support.BeanDefinitionBuilder;
import org.springframework.beans.factory.support.RootBeanDefinition;
import org.springframework.beans.factory.xml.BeanDefinitionParser;
import org.springframework.beans.factory.xml.NamespaceHandlerSupport;
import org.springframework.beans.factory.xml.ParserContext;
import org.w3c.dom.Element;

public class DatabaseConstraintsXmlNamespaceHandler
extends NamespaceHandlerSupport {
    private static final String POINTCUT = "pointcut";
    private static final String DATA_SOURCE = "data-source";
    private static final String BASE_PACKAGE = "base-package";
    private static final String ENTITY_MANAGER_FACTORY = "entity-manager-factory";
    private static final String DEFAULT_EXCEPTION_FACTORY = "default-exception-factory";

    public void init() {
        this.registerBeanDefinitionParser("enable-constraints", new EnableConstraintBeanDefinitionParser());
    }

    private static class EnableConstraintBeanDefinitionParser
    implements BeanDefinitionParser {
        private EnableConstraintBeanDefinitionParser() {
        }

        public BeanDefinition parse(Element element, ParserContext parserContext) {
            String beanMetadataRepositoryName = this.buildAndRegisterBeanMetadataRepository(element, parserContext);
            this.buildAndRegisterConstraintDescriptor(beanMetadataRepositoryName, element, parserContext);
            this.buildAndRegisterExceptionTranslatingPostProcessor(element, parserContext);
            return null;
        }

        private String buildAndRegisterBeanMetadataRepository(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder beanMetadataRepositoryBuilder = BeanDefinitionBuilder.genericBeanDefinition(BeanMetadataRepositoryFactoryBean.class);
            if (element.hasAttribute(DatabaseConstraintsXmlNamespaceHandler.ENTITY_MANAGER_FACTORY)) {
                beanMetadataRepositoryBuilder.addConstructorArgReference(element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.ENTITY_MANAGER_FACTORY));
            } else {
                beanMetadataRepositoryBuilder.addConstructorArgReference(element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.DATA_SOURCE));
            }
            return parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanMetadataRepositoryBuilder.getBeanDefinition());
        }

        private void buildAndRegisterConstraintDescriptor(String beanMetadataRepositoryName, Element element, ParserContext parserContext) {
            BeanDefinitionBuilder beanConstraintDescriptorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DefaultBeanConstraintDescriptor.class);
            beanConstraintDescriptorBuilder.addConstructorArgReference(beanMetadataRepositoryName);
            parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)beanConstraintDescriptorBuilder.getBeanDefinition());
        }

        private void buildAndRegisterExceptionTranslatingPostProcessor(Element element, ParserContext parserContext) {
            BeanDefinitionBuilder processorBuilder = BeanDefinitionBuilder.genericBeanDefinition(TranslateExceptionsBeanPostProcessor.class);
            processorBuilder.addConstructorArgValue((Object)this.buildExceptionTranslator(element));
            if (element.hasAttribute(DatabaseConstraintsXmlNamespaceHandler.POINTCUT)) {
                processorBuilder.addConstructorArgValue((Object)this.buildPointcut(element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.POINTCUT)));
            }
            parserContext.getReaderContext().registerWithGeneratedName((BeanDefinition)processorBuilder.getBeanDefinition());
        }

        private BeanDefinition buildExceptionTranslator(Element element) {
            BeanDefinitionBuilder translatorBuilder = BeanDefinitionBuilder.genericBeanDefinition(DatabaseConstraintExceptionTranslatorFactoryBean.class);
            translatorBuilder.addPropertyValue("basePackage", (Object)element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.BASE_PACKAGE));
            if (element.hasAttribute(DatabaseConstraintsXmlNamespaceHandler.ENTITY_MANAGER_FACTORY)) {
                translatorBuilder.addConstructorArgReference(element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.ENTITY_MANAGER_FACTORY));
            } else {
                translatorBuilder.addConstructorArgReference(element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.DATA_SOURCE));
            }
            if (element.hasAttribute(DatabaseConstraintsXmlNamespaceHandler.DEFAULT_EXCEPTION_FACTORY)) {
                translatorBuilder.addPropertyReference("defaultExceptionFactory", element.getAttribute(DatabaseConstraintsXmlNamespaceHandler.DEFAULT_EXCEPTION_FACTORY));
            }
            return translatorBuilder.getBeanDefinition();
        }

        private BeanDefinition buildPointcut(String expression) {
            RootBeanDefinition beanDefinition = new RootBeanDefinition(AspectJExpressionPointcut.class);
            beanDefinition.setScope("prototype");
            beanDefinition.setSynthetic(true);
            beanDefinition.getPropertyValues().add("expression", (Object)expression);
            return beanDefinition;
        }
    }
}

