/*
 * Decompiled with CFR 0.152.
 */
package org.jarbframework.constraint;

import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.persistence.EntityManagerFactory;
import javax.sql.DataSource;
import org.jarbframework.constraint.DatabaseConstraintsConfigurer;
import org.jarbframework.constraint.EnableDatabaseConstraints;
import org.jarbframework.constraint.metadata.BeanConstraintDescriptor;
import org.jarbframework.constraint.metadata.DefaultBeanConstraintDescriptor;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepository;
import org.jarbframework.constraint.metadata.database.BeanMetadataRepositoryFactoryBean;
import org.jarbframework.constraint.violation.DatabaseConstraintExceptionTranslator;
import org.jarbframework.constraint.violation.TranslateExceptionsBeanPostProcessor;
import org.jarbframework.constraint.violation.factory.ConfigurableConstraintExceptionFactory;
import org.jarbframework.constraint.violation.factory.DatabaseConstraintExceptionFactory;
import org.jarbframework.constraint.violation.resolver.ConfigurableViolationResolver;
import org.jarbframework.constraint.violation.resolver.DatabaseConstraintViolationResolver;
import org.jarbframework.utils.StringUtils;
import org.jarbframework.utils.orm.hibernate.HibernateUtils;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.ImportAware;
import org.springframework.core.type.AnnotationMetadata;

@Configuration
public class DatabaseConstraintsConfiguration
implements ImportAware,
InitializingBean {
    private static final String BASE_PACKAGES_REF = "basePackages";
    private static final String BASE_CLASSES_REF = "baseClasses";
    private static final String DATA_SOURCE_REF = "dataSource";
    private static final String ENTITY_MANAGER_FACTORY_REF = "entityManagerFactory";
    private static final String TRANSLATE_REF = "translate";
    private Map<String, Object> attributes;
    @Autowired(required=false)
    private Set<DatabaseConstraintsConfigurer> configurers = new HashSet<DatabaseConstraintsConfigurer>();
    private Set<String> basePackages;
    @Autowired
    private ApplicationContext applicationContext;
    private EntityManagerFactory entityManagerFactory;
    private DataSource dataSource;

    @Bean
    public DatabaseConstraintExceptionTranslator exceptionTranslator() throws Exception {
        return new DatabaseConstraintExceptionTranslator(this.violationResolver(), this.exceptionFactory());
    }

    @Bean
    public DatabaseConstraintViolationResolver violationResolver() {
        ConfigurableViolationResolver violationResolver = new ConfigurableViolationResolver(this.dataSource, this.basePackages);
        for (DatabaseConstraintsConfigurer configurer : this.configurers) {
            configurer.addViolationResolvers(violationResolver);
        }
        return violationResolver;
    }

    @Bean
    public DatabaseConstraintExceptionFactory exceptionFactory() {
        ConfigurableConstraintExceptionFactory exceptionFactory = new ConfigurableConstraintExceptionFactory();
        for (DatabaseConstraintsConfigurer configurer : this.configurers) {
            configurer.addConstraintExceptions(exceptionFactory);
        }
        for (String basePackage : this.basePackages) {
            exceptionFactory.registerAll(basePackage);
        }
        return exceptionFactory;
    }

    @Bean
    public TranslateExceptionsBeanPostProcessor exceptionTranslatingBeanPostProcessor() throws Exception {
        Class annotation = (Class)this.attributes.get(TRANSLATE_REF);
        return new TranslateExceptionsBeanPostProcessor(this.exceptionTranslator(), annotation);
    }

    @Bean
    public BeanMetadataRepository beanMetadataRepository() throws Exception {
        if (this.entityManagerFactory != null) {
            return (BeanMetadataRepository)new BeanMetadataRepositoryFactoryBean(this.entityManagerFactory).getObject();
        }
        return (BeanMetadataRepository)new BeanMetadataRepositoryFactoryBean(this.dataSource).getObject();
    }

    @Bean
    public BeanConstraintDescriptor beanConstraintDescriptor() throws Exception {
        DefaultBeanConstraintDescriptor beanConstraintDescriptor = new DefaultBeanConstraintDescriptor(this.beanMetadataRepository());
        for (DatabaseConstraintsConfigurer configurer : this.configurers) {
            configurer.addPropertyEnhancers(beanConstraintDescriptor);
        }
        return beanConstraintDescriptor;
    }

    public void setImportMetadata(AnnotationMetadata importMetadata) {
        this.attributes = importMetadata.getAnnotationAttributes(EnableDatabaseConstraints.class.getName());
    }

    public void afterPropertiesSet() throws Exception {
        String entityManagerFactoryName = (String)this.attributes.get(ENTITY_MANAGER_FACTORY_REF);
        String dataSourceName = (String)this.attributes.get(DATA_SOURCE_REF);
        if (this.applicationContext.containsBean(entityManagerFactoryName)) {
            this.entityManagerFactory = (EntityManagerFactory)this.applicationContext.getBean(entityManagerFactoryName, EntityManagerFactory.class);
            this.dataSource = HibernateUtils.getDataSource((EntityManagerFactory)this.entityManagerFactory);
        } else {
            this.dataSource = (DataSource)this.applicationContext.getBean(dataSourceName, DataSource.class);
        }
        String[] basePackages = (String[])this.attributes.get(BASE_PACKAGES_REF);
        Class[] baseClasses = (Class[])this.attributes.get(BASE_CLASSES_REF);
        this.basePackages = new HashSet<String>();
        this.basePackages.addAll(Arrays.asList(basePackages));
        for (Class baseClass : baseClasses) {
            String basePackage = this.getPackage(baseClass);
            this.basePackages.add(basePackage);
        }
    }

    private String getPackage(Class<?> baseClass) {
        return StringUtils.substringBeforeLast((String)baseClass.getName(), (String)".");
    }
}

