/*
 * Decompiled with CFR 0.152.
 */
package org.janusgraph.diskstorage.mixed.utils.processor;

import org.janusgraph.core.attribute.Geoshape;
import org.janusgraph.diskstorage.configuration.Configuration;
import org.janusgraph.diskstorage.mixed.utils.MixedIndexUtilsConfigOptions;
import org.janusgraph.diskstorage.mixed.utils.processor.ErrorDistanceCircleProcessor;

public class DynamicErrorDistanceCircleProcessor
extends ErrorDistanceCircleProcessor {
    public static final String SHORTHAND = "dynamicErrorDistance";
    private final double errorDistanceMultiplier;

    public DynamicErrorDistanceCircleProcessor(Configuration config) {
        super((Boolean)config.get(MixedIndexUtilsConfigOptions.BKD_DYNAMIC_CIRCLE_PROCESSOR_BOUNDING_BOX_FALLBACK, new String[0]));
        this.errorDistanceMultiplier = (Double)config.get(MixedIndexUtilsConfigOptions.BKD_DYNAMIC_CIRCLE_PROCESSOR_MULTIPLIER, new String[0]);
    }

    @Override
    double getErrorDistanceMeters(Geoshape circle) {
        double radius = circle.getRadiusMeters();
        double errorDistance = (radius <= 2.0 ? 1.0 : Math.log(radius)) * this.errorDistanceMultiplier;
        return errorDistance <= 0.0 ? Double.MIN_VALUE : errorDistance;
    }
}

